/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.prediction.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.prediction.api.PredictionAwareHumanTaskLifeCycle;
import org.kie.kogito.prediction.api.PredictionOutcome;
import org.kie.kogito.prediction.api.PredictionService;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.CachedWorkItemHandlerConfig;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.process.workitem.LifeCycle;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;

public class PredictionAwareHumanTaskLifeCycleTest {
    private Policy<?> securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));
    private AtomicBoolean predictNow;
    private List<String> trainedTasks;
    private PredictionService predictionService;
    private ProcessConfig config;

    @BeforeEach
    public void configure() {
        this.predictNow = new AtomicBoolean(false);
        this.trainedTasks = new ArrayList<String>();
        this.predictionService = new PredictionService(){

            public void train(WorkItem task, Map<String, Object> inputData, Map<String, Object> outputData) {
                PredictionAwareHumanTaskLifeCycleTest.this.trainedTasks.add(task.getId());
            }

            public PredictionOutcome predict(WorkItem task, Map<String, Object> inputData) {
                if (PredictionAwareHumanTaskLifeCycleTest.this.predictNow.get()) {
                    return new PredictionOutcome(95.0, 75.0, Collections.singletonMap("output", "predicted value"));
                }
                return new PredictionOutcome();
            }

            public String getIdentifier() {
                return "test";
            }
        };
        CachedWorkItemHandlerConfig wiConfig = new CachedWorkItemHandlerConfig();
        wiConfig.register("Human Task", (WorkItemHandler)new HumanTaskWorkItemHandler((LifeCycle)new PredictionAwareHumanTaskLifeCycle(this.predictionService)));
        this.config = new StaticProcessConfig((WorkItemHandlerConfig)wiConfig, (ProcessEventListenerConfig)new DefaultProcessEventListenerConfig(new ProcessEventListener[0]), (UnitOfWorkManager)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()), null);
    }

    @Test
    public void testUserTaskWithPredictionService() {
        this.predictNow.set(true);
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask.bpmn2"), (ProcessConfig)this.config).get(0);
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        Assertions.assertEquals((Object)"predicted value", result.toMap().get("s"));
        Assertions.assertEquals((int)0, (int)this.trainedTasks.size());
    }

    @Test
    public void testUserTaskWithoutPredictionService() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask.bpmn2"), (ProcessConfig)this.config).get(0);
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        org.kie.kogito.process.WorkItem workItem = (org.kie.kogito.process.WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", workItem.getParameters().get("ActorId"));
        processInstance.completeWorkItem(workItem.getId(), Collections.singletonMap("output", "given value"), new Policy[]{this.securityPolicy});
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        Assertions.assertEquals((Object)"given value", result.toMap().get("s"));
        Assertions.assertEquals((int)1, (int)this.trainedTasks.size());
    }
}

