/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.prediction.api;

import java.util.Map;
import java.util.Objects;
import org.jbpm.process.instance.impl.humantask.BaseHumanTaskLifeCycle;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.kie.api.runtime.process.WorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.prediction.api.PredictionOutcome;
import org.kie.kogito.prediction.api.PredictionService;
import org.kie.kogito.process.workitem.InvalidLifeCyclePhaseException;
import org.kie.kogito.process.workitem.LifeCyclePhase;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredictionAwareHumanTaskLifeCycle
extends BaseHumanTaskLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(PredictionAwareHumanTaskLifeCycle.class);
    private PredictionService predictionService;

    public PredictionAwareHumanTaskLifeCycle(PredictionService predictionService) {
        this.predictionService = Objects.requireNonNull(predictionService);
    }

    public Map<String, Object> transitionTo(KogitoWorkItem workItem, KogitoWorkItemManager manager, Transition<Map<String, Object>> transition) {
        LifeCyclePhase targetPhase = this.phaseById(transition.phase());
        if (targetPhase == null) {
            logger.debug("Target life cycle phase '{}' does not exist in {}", (Object)transition.phase(), (Object)((Object)((Object)this)).getClass().getSimpleName());
            throw new InvalidLifeCyclePhaseException(transition.phase());
        }
        HumanTaskWorkItemImpl humanTaskWorkItem = (HumanTaskWorkItemImpl)workItem;
        if (targetPhase.id().equals("active")) {
            PredictionOutcome outcome = this.predictionService.predict((WorkItem)workItem, workItem.getParameters());
            logger.debug("Prediction service returned confidence level {} for work item {}", (Object)outcome.getConfidenceLevel(), (Object)humanTaskWorkItem.getStringId());
            if (outcome.isCertain()) {
                humanTaskWorkItem.getResults().putAll(outcome.getData());
                logger.debug("Prediction service is certain (confidence level {}) on the outputs, completing work item {}", (Object)outcome.getConfidenceLevel(), (Object)humanTaskWorkItem.getStringId());
                ((InternalKogitoWorkItemManager)manager).internalCompleteWorkItem((InternalKogitoWorkItem)humanTaskWorkItem);
                return outcome.getData();
            }
            if (outcome.isPresent()) {
                logger.debug("Prediction service is NOT certain (confidence level {}) on the outputs, setting recommended outputs on work item {}", (Object)outcome.getConfidenceLevel(), (Object)humanTaskWorkItem.getStringId());
                humanTaskWorkItem.getResults().putAll(outcome.getData());
            }
        }
        Map data = super.transitionTo(workItem, manager, transition);
        if (targetPhase.id().equals("complete")) {
            this.predictionService.train((WorkItem)humanTaskWorkItem, workItem.getParameters(), data);
        }
        return data;
    }
}

