/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.dmn;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DMNIT {
    static final String ADULT_PAYLOAD = "{\n  \"p\": {\n    \"addresses\": [\n      {\n        \"streetName\": \"Street Name\",\n        \"streetNumber\": 1\n      },\n      {\n        \"streetName\": \"Another street name\",\n        \"streetNumber\": 2\n      }\n    ],\n    \"name\": \"Luca\"\n  }\n}";

    @Test
    public void testOASdmnDefinitions() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/dmnDefinitions.json", new Object[0])).then()).statusCode(200)).body("definitions", Matchers.aMapWithSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))), new Object[0]);
    }

    @Test
    public void testAdult() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(ADULT_PAYLOAD).post("/dmnModel", new Object[0])).then()).statusCode(200)).body("d.Hello", Matchers.is((Object)"Hello Luca"), new Object[0]);
    }

    @Test
    public void testAdult_dmnResult() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(ADULT_PAYLOAD).post("/dmnModel/dmnresult", new Object[0])).then()).statusCode(200)).body("dmnContext.d.Hello", Matchers.is((Object)"Hello Luca"), new Object[0]);
    }

    @Test
    public void allTypes() {
        String payload = "{\n  \"InputBoolean\": true,\n  \"InputDTDuration\": \"P1D\",\n  \"InputDate\": \"2020-04-17\",\n  \"InputDateAndTime\": \"2020-04-17T10:03:51.615Z\",\n  \"InputNumber\": 0,\n  \"InputString\": \"string\",\n  \"InputTime\": \"13:45\",\n  \"InputYMDuration\": \"P1M\"\n}";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(payload).post("/OneOfEachType", new Object[0])).then()).statusCode(200);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

