/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.quarkus.deployment.MemoryClassLoader;

public class MemoryClassLoaderTest {
    @Test
    public void testMemoryClassLoader() throws IOException, ReflectiveOperationException, URISyntaxException {
        String className = "/" + MemoryClassLoaderTest.class.getName().replace('.', '/');
        URL url = MemoryClassLoaderTest.class.getResource(className.concat(".class"));
        MemoryFileSystem fs = new MemoryFileSystem();
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();
             InputStream input = Files.newInputStream(Paths.get(url.toURI()), new OpenOption[0]);){
            this.transferTo(input, bytes);
            fs.write(className.concat(".class"), bytes.toByteArray());
        }
        MemoryClassLoader cl = new MemoryClassLoader(fs, null);
        Class clazz = cl.loadClass(MemoryClassLoaderTest.class.getName());
        Assertions.assertTrue((boolean)Modifier.isPublic(clazz.getMethod("testMemoryClassLoader", new Class[0]).getModifiers()));
        Assertions.assertThrows(NoSuchFieldException.class, () -> clazz.getField("otherField"));
    }

    private void transferTo(InputStream in, OutputStream out) throws IOException {
        int size;
        byte[] buffer = new byte[1000];
        while ((size = in.read(buffer)) != -1) {
            out.write(buffer, 0, size);
        }
    }
}

