/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.kie.api.pmml.PMML4Result;
import org.kie.kogito.Model;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.Generated;
import org.kie.kogito.codegen.VariableInfo;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.kie.kogito.codegen.core.utils.ApplicationGeneratorDiscovery;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;
import org.kie.kogito.codegen.core.utils.GeneratedFileWriter;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.event.AbstractDataEvent;
import org.kie.kogito.quarkus.deployment.InMemoryCompiler;
import org.kie.kogito.quarkus.deployment.JandexProtoGenerator;
import org.kie.kogito.quarkus.deployment.KogitoCompilationProvider;
import org.kie.kogito.quarkus.deployment.KogitoQuarkusContextProvider;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluatorFinderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoAssetsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KogitoAssetsProcessor.class);
    public static final String targetClassesDir = "target/classes";
    private static final GeneratedFileWriter.Builder generatedFileWriterBuilder = new GeneratedFileWriter.Builder("target/classes", System.getProperty("kogito.codegen.sources.directory", "target/generated-sources/kogito/"), System.getProperty("kogito.codegen.resources.directory", "target/generated-resources/kogito/"), "target/generated-sources/kogito/");
    private static final DotName persistenceFactoryClass = DotName.createSimple((String)"org.kie.kogito.persistence.KogitoProcessInstancesFactory");
    private static final DotName quarkusSVGService = DotName.createSimple((String)"org.kie.kogito.svg.service.QuarkusProcessSvgService");
    private static final PathMatcher svgFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.svg");
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("kogito");
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito");
    }

    @BuildStep
    public void generateModel(BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedResourceBuildItem> genResBI, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration) throws IOException {
        if (this.liveReload.isLiveReload()) {
            return;
        }
        boolean useProcessSVG = this.combinedIndexBuildItem.getIndex().getClassByName(quarkusSVGService) != null;
        KogitoBuildContext context = this.kogitoBuildContext();
        Collection generatedFiles = ApplicationGeneratorDiscovery.discover((KogitoBuildContext)context).generate();
        this.dumpFilesToDisk(context.getAppPaths(), generatedFiles);
        Index index = this.processGeneratedJavaSourceCode(context, generatedFiles, generatedBeans);
        if (index == null) {
            return;
        }
        generatedFiles.addAll(this.generatePersistenceInfo(context, (IndexView)index, generatedBeans, resource, reflectiveClass, runTimeConfiguration));
        generatedFiles.addAll(this.generateJsonSchema(context, index));
        this.dumpFilesToDisk(context.getAppPaths(), generatedFiles);
        this.registerResources(generatedFiles, resource, genResBI);
        this.registerDataEventsForReflection(index, context, reflectiveClass);
        if (useProcessSVG) {
            this.registerProcessSVG(context.getAppPaths(), resource);
        }
    }

    private KogitoBuildContext kogitoBuildContext() {
        AppPaths appPaths = AppPaths.fromQuarkus((Iterable)this.root.getPaths());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return KogitoQuarkusContextProvider.context(appPaths, classLoader, className -> this.classAvailabilityResolver(classLoader, (String)className));
    }

    private boolean classAvailabilityResolver(ClassLoader classLoader, String className) {
        DotName classDotName;
        boolean classFound;
        IndexView index = this.combinedIndexBuildItem.getIndex();
        boolean bl = classFound = !index.getAnnotations(classDotName = DotName.createSimple((String)className)).isEmpty() || index.getClassByName(classDotName) != null;
        if (classFound) {
            return true;
        }
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void dumpFilesToDisk(AppPaths appPaths, Collection<GeneratedFile> generatedFiles) {
        generatedFileWriterBuilder.build(appPaths.getFirstProjectPath()).writeAll(generatedFiles);
    }

    private void registerResources(Collection<GeneratedFile> generatedFiles, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<GeneratedResourceBuildItem> genResBI) {
        for (GeneratedFile f : generatedFiles) {
            if (f.category() != GeneratedFileType.Category.RESOURCE) continue;
            genResBI.produce((BuildItem)new GeneratedResourceBuildItem(f.relativePath(), f.contents()));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{f.relativePath()}));
        }
    }

    private Index processGeneratedJavaSourceCode(KogitoBuildContext context, Collection<GeneratedFile> generatedFiles, BuildProducer<GeneratedBeanBuildItem> generatedBeans) throws IOException {
        Collection javaFiles = generatedFiles.stream().filter(f -> f.category() == GeneratedFileType.Category.SOURCE).collect(Collectors.toList());
        if (javaFiles.isEmpty()) {
            return null;
        }
        InMemoryCompiler inMemoryCompiler = new InMemoryCompiler(context.getAppPaths().getClassesPaths(), this.curateOutcomeBuildItem.getEffectiveModel().getUserDependencies());
        inMemoryCompiler.compile(javaFiles);
        MemoryFileSystem trgMfs = inMemoryCompiler.getTargetFileSystem();
        Collection<GeneratedBeanBuildItem> generatedBeanBuildItems = this.makeBuildItems(context.getAppPaths(), trgMfs);
        generatedBeanBuildItems.forEach(arg_0 -> generatedBeans.produce(arg_0));
        return this.indexBuildItems(context, generatedBeanBuildItems);
    }

    private Collection<GeneratedFile> generatePersistenceInfo(KogitoBuildContext context, IndexView inputIndex, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration) throws IOException {
        CompositeIndex index = CompositeIndex.create((IndexView[])new IndexView[]{this.combinedIndexBuildItem.getIndex(), inputIndex});
        Collection<GeneratedFile> persistenceGeneratedFiles = this.getGeneratedPersistenceFiles((IndexView)index, context, reflectiveClass, runTimeConfiguration);
        GeneratedFileValidation.validateGeneratedFileTypes(persistenceGeneratedFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.RESOURCE));
        Collection persistenceClasses = persistenceGeneratedFiles.stream().filter(x -> x.category().equals((Object)GeneratedFileType.Category.SOURCE)).collect(Collectors.toList());
        Collection persistenceProtoFiles = persistenceGeneratedFiles.stream().filter(x -> x.category().equals((Object)GeneratedFileType.Category.RESOURCE)).collect(Collectors.toList());
        if (!persistenceClasses.isEmpty()) {
            InMemoryCompiler inMemoryCompiler = new InMemoryCompiler(context.getAppPaths().getClassesPaths(), this.curateOutcomeBuildItem.getEffectiveModel().getUserDependencies());
            inMemoryCompiler.compile(persistenceClasses);
            Collection<GeneratedBeanBuildItem> generatedBeanBuildItems = this.makeBuildItems(context.getAppPaths(), inMemoryCompiler.getTargetFileSystem());
            generatedBeanBuildItems.forEach(arg_0 -> generatedBeans.produce(arg_0));
        }
        if (context.getAddonsConfig().usePersistence()) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
        }
        return persistenceProtoFiles;
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(IndexView index, KogitoBuildContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration) {
        ClassInfo persistenceClass = index.getClassByName(persistenceFactoryClass);
        Collection modelClasses = index.getAllKnownImplementors(DotName.createSimple((String)Model.class.getCanonicalName()));
        JandexProtoGenerator protoGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(index, DotName.createSimple((String)Generated.class.getCanonicalName()), DotName.createSimple((String)VariableInfo.class.getCanonicalName())).withPersistenceClass((Object)persistenceClass).build(modelClasses);
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator);
        if (persistenceGenerator.persistenceType().equals("mongodb")) {
            this.addInnerClasses(JBPMMessages.class, reflectiveClass);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"java.lang.String"}));
        } else if (persistenceGenerator.persistenceType().equals("kafka")) {
            String processIds = protoGenerator.getProcessIds().stream().map(s -> "kogito.process." + s).collect(Collectors.joining(","));
            runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.kafka-streams.topics", processIds));
        }
        return persistenceGenerator.generate();
    }

    private void addInnerClasses(Class<?> superClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Arrays.asList(superClass.getDeclaredClasses()).forEach(c -> {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.getName()}));
            this.addInnerClasses((Class<?>)c, reflectiveClass);
        });
    }

    @BuildStep
    public List<ReflectiveHierarchyIgnoreWarningBuildItem> reflectiveDMNREST() {
        ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem> result = new ArrayList<ReflectiveHierarchyIgnoreWarningBuildItem>();
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.api.builder.Message$Level")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNContext")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNDecisionResult")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNDecisionResult$DecisionEvaluationStatus")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessage")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessage$Severity")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.core.DMNMessageType")));
        result.add(new ReflectiveHierarchyIgnoreWarningBuildItem(DotName.createSimple((String)"org.kie.dmn.api.feel.runtime.events.FEELEvent")));
        return result;
    }

    @BuildStep
    public List<ReflectiveClassBuildItem> reflectivePredictions() {
        logger.debug("reflectivePredictions()");
        PMMLModelEvaluatorFinderImpl pmmlModelEvaluatorFinder = new PMMLModelEvaluatorFinderImpl();
        List pmmlEvaluators = pmmlModelEvaluatorFinder.getImplementations(false);
        logger.debug("pmmlEvaluators {}", (Object)pmmlEvaluators.size());
        ArrayList<ReflectiveClassBuildItem> toReturn = new ArrayList<ReflectiveClassBuildItem>();
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{PMML4Result.class}));
        pmmlEvaluators.forEach(pmmlModelEvaluator -> toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{pmmlModelEvaluator.getClass()})));
        logger.debug("toReturn {}", (Object)toReturn.size());
        return toReturn;
    }

    @BuildStep
    public NativeImageResourceBuildItem predictionSPI() {
        logger.debug("predictionSPI()");
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator"});
    }

    @BuildStep
    public ReflectiveClassBuildItem reflectionJobsManagement() {
        return new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.jobs.api.Job"});
    }

    private void registerProcessSVG(AppPaths appPaths, BuildProducer<NativeImageResourceBuildItem> resource) throws IOException {
        Path relativePath = Paths.get("META-INF", "processSVG");
        Path targetClasses = appPaths.getFirstProjectPath().resolve(targetClassesDir);
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"org/apache/batik/util/resources/XMLResourceDescriptor.properties"}));
        Path resolvedPath = targetClasses.resolve(relativePath);
        try (Stream<Path> filePathFound = Files.find(resolvedPath, Integer.MAX_VALUE, (filePath, attrs) -> svgFileMatcher.matches((Path)filePath), new FileVisitOption[0]);){
            List svgs = filePathFound.map(svgPath -> targetClasses.relativize((Path)svgPath).toString()).collect(Collectors.toList());
            resource.produce((BuildItem)new NativeImageResourceBuildItem(svgs));
        }
    }

    private Collection<GeneratedFile> generateJsonSchema(KogitoBuildContext context, Index index) throws IOException {
        Path targetClasses = context.getAppPaths().getFirstProjectPath().resolve(targetClassesDir);
        URL[] urls = new URL[]{targetClasses.toUri().toURL()};
        try (URLClassLoader cl = new URLClassLoader(urls, context.getClassLoader());){
            List annotations = index.getAnnotations(DotName.createSimple((String)UserTask.class.getCanonicalName()));
            Stream<Class> stream = annotations.stream().map(ann -> this.loadClassFromAnnotation((AnnotationInstance)ann, cl)).filter(Optional::isPresent).map(Optional::get);
            JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator.ClassBuilder(stream).withGenSchemaPredicate(x -> true).withSchemaVersion(System.getProperty("kogito.jsonSchema.version")).build();
            Collection collection = jsonSchemaGenerator.generate();
            return collection;
        }
    }

    private Optional<Class<?>> loadClassFromAnnotation(AnnotationInstance annotationInstance, ClassLoader classLoader) {
        try {
            return Optional.of(classLoader.loadClass(annotationInstance.target().asClass().name().toString()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private void registerDataEventsForReflection(Index index, KogitoBuildContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.event.AbstractDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.AbstractProcessDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.ProcessInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.VariableInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.NodeInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.ProcessErrorEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.VariableInstanceEventBody"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.UserTaskInstanceDataEvent"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.services.event.impl.UserTaskInstanceEventBody"}));
        if (context.getAddonsConfig().useMonitoring()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.HdrHistogram.Histogram"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.HdrHistogram.ConcurrentHistogram"}));
        }
        this.addChildrenClasses(index, AbstractDataEvent.class, reflectiveClass);
        this.addChildrenClasses(index, AbstractProcessDataEvent.class, reflectiveClass);
    }

    private void addChildrenClasses(Index index, Class<?> superClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        index.getAllKnownSubclasses(DotName.createSimple((String)superClass.getCanonicalName())).forEach(c -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{c.name().toString()})));
    }

    private Index indexBuildItems(KogitoBuildContext context, Collection<GeneratedBeanBuildItem> buildItems) {
        Indexer kogitoIndexer = new Indexer();
        HashSet kogitoIndex = new HashSet();
        for (GeneratedBeanBuildItem generatedBeanBuildItem : buildItems) {
            IndexingUtil.indexClass((String)generatedBeanBuildItem.getName(), (Indexer)kogitoIndexer, (IndexView)this.combinedIndexBuildItem.getIndex(), kogitoIndex, (ClassLoader)context.getClassLoader(), (byte[])generatedBeanBuildItem.getData());
        }
        return kogitoIndexer.complete();
    }

    private Collection<GeneratedBeanBuildItem> makeBuildItems(AppPaths appPaths, MemoryFileSystem trgMfs) throws IOException {
        ArrayList<GeneratedBeanBuildItem> buildItems = new ArrayList<GeneratedBeanBuildItem>();
        Path location = appPaths.getFirstProjectPath().resolve(targetClassesDir);
        for (String fileName : trgMfs.getFileNames()) {
            byte[] data = trgMfs.getBytes(fileName);
            String className = this.toClassName(fileName);
            buildItems.add(new GeneratedBeanBuildItem(className, data));
            Path path = this.pathOf(location.toString(), fileName);
            Files.write(path, data, new OpenOption[0]);
            String sourceFile = location.toString().replaceFirst("\\.class", ".java");
            if (sourceFile.contains("$")) {
                sourceFile = sourceFile.substring(0, sourceFile.indexOf("$")) + ".java";
            }
            KogitoCompilationProvider.classToSource.put(path, Paths.get(sourceFile, new String[0]));
        }
        return buildItems;
    }

    private String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.');
    }

    private Path pathOf(String location, String end) {
        Path path = Paths.get(location, end);
        path.getParent().toFile().mkdirs();
        return path;
    }
}

