/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.prediction.incubation.quarkus.support;

import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.api.pmml.PMML4Result;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.objectmapper.InternalObjectMapper;
import org.kie.kogito.incubation.predictions.LocalPredictionId;
import org.kie.kogito.incubation.predictions.services.PredictionService;
import org.kie.kogito.prediction.PredictionModel;
import org.kie.kogito.prediction.PredictionModels;
import org.kie.pmml.api.runtime.PMMLContext;

@ApplicationScoped
public class QuarkusPredictionService
implements PredictionService {
    @Inject
    Instance<PredictionModels> predictionModels;

    public ExtendedDataContext evaluate(LocalId predictionId, DataContext inputContext) {
        if (!(predictionId instanceof LocalPredictionId)) {
            throw new IllegalArgumentException("Not a valid prediction id " + predictionId.toLocalId());
        }
        LocalPredictionId localPredictionId = (LocalPredictionId)predictionId;
        PredictionModel predictionModel = ((PredictionModels)this.predictionModels.get()).getPredictionModel(localPredictionId.name());
        PMMLContext ctx = predictionModel.newContext(((MapDataContext)inputContext.as(MapDataContext.class)).toMap());
        PMML4Result pmml4Result = predictionModel.evaluateAll(ctx);
        Map resultMap = Collections.singletonMap(pmml4Result.getResultObjectName(), pmml4Result.getResultVariables().get(pmml4Result.getResultObjectName()));
        MapDataContext meta = MapDataContext.of((Map)((Map)InternalObjectMapper.objectMapper().convertValue((Object)pmml4Result, Map.class)));
        MapDataContext data = MapDataContext.of(resultMap);
        return ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
    }
}

