/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoEnum;
import org.kie.kogito.codegen.process.persistence.proto.ProtoMessage;
import org.kie.kogito.quarkus.Address;
import org.kie.kogito.quarkus.EmptyConstructor;
import org.kie.kogito.quarkus.GeneratedPOJO;
import org.kie.kogito.quarkus.NotEmptyConstructor;
import org.kie.kogito.quarkus.Person;
import org.kie.kogito.quarkus.processes.deployment.JandexProtoGenerator;

class JandexProtoGeneratorTest {
    JandexProtoGeneratorTest() {
    }

    @Test
    void testGenerate() {
        ArrayList<ClassInfo> dataClasses = new ArrayList<ClassInfo>();
        DotName enumName = DotName.createComponentized((DotName)DotName.createComponentized((DotName)DotName.createComponentized(null, (String)"com"), (String)"acme"), (String)"ExampleEnum");
        ClassInfo enumClassInfo = ClassInfo.create((DotName)enumName, (DotName)DotName.createSimple((String)Enum.class.getName()), (short)0, (DotName[])new DotName[0], new HashMap(), (boolean)false);
        dataClasses.add(enumClassInfo);
        DotName objectName = DotName.createComponentized((DotName)DotName.createComponentized((DotName)DotName.createComponentized(null, (String)"com"), (String)"acme"), (String)"ExampleObject");
        ClassInfo objectClassName = ClassInfo.create((DotName)objectName, (DotName)DotName.createSimple((String)Object.class.getName()), (short)0, (DotName[])new DotName[0], new HashMap(), (boolean)false);
        dataClasses.add(objectClassName);
        JandexProtoGenerator generator = (JandexProtoGenerator)JandexProtoGenerator.builder(null, null, null).withDataClasses(dataClasses).build(null);
        Proto proto = generator.protoOfDataClasses("com.acme", new String[0]);
        Assertions.assertEquals((int)1, (int)proto.getEnums().size());
        Assertions.assertEquals((Object)enumName.local(), (Object)((ProtoEnum)proto.getEnums().get(0)).getName());
        Assertions.assertEquals((int)1, (int)proto.getMessages().size());
        Assertions.assertEquals((Object)objectName.local(), (Object)((ProtoMessage)proto.getMessages().get(0)).getName());
    }

    @Test
    void testGenerateComments() {
        ArrayList<ClassInfo> dataModel = new ArrayList<ClassInfo>();
        DotName enumName = DotName.createComponentized((DotName)DotName.createComponentized((DotName)DotName.createComponentized(null, (String)"com"), (String)"acme"), (String)"ExampleEnum");
        ClassInfo enumClassInfo = ClassInfo.create((DotName)enumName, (DotName)DotName.createSimple((String)Enum.class.getName()), (short)0, (DotName[])new DotName[0], new HashMap(), (boolean)false);
        dataModel.add(enumClassInfo);
        DotName objectName = DotName.createComponentized((DotName)DotName.createComponentized((DotName)DotName.createComponentized(null, (String)"com"), (String)"acme"), (String)"ExampleObject");
        ClassInfo objectClassName = ClassInfo.create((DotName)objectName, (DotName)DotName.createSimple((String)Object.class.getName()), (short)0, (DotName[])new DotName[0], new HashMap(), (boolean)false);
        dataModel.add(objectClassName);
        JandexProtoGenerator generator = (JandexProtoGenerator)JandexProtoGenerator.builder(null, null, null).withDataClasses(dataModel).build(null);
        Proto enumProto = generator.generate("message comment", "field comment", "com.acme", enumClassInfo, new String[0]);
        Assertions.assertEquals((int)1, (int)enumProto.getEnums().size());
        Assertions.assertEquals((Object)enumName.local(), (Object)((ProtoEnum)enumProto.getEnums().get(0)).getName());
        Proto objectProto = generator.generate("message comment", "field comment", "com.acme", objectClassName, new String[0]);
        Assertions.assertEquals((int)1, (int)objectProto.getMessages().size());
        Assertions.assertEquals((Object)objectName.local(), (Object)((ProtoMessage)objectProto.getMessages().get(0)).getName());
    }

    @Test
    void builderTest() throws IOException {
        Indexer indexer = new Indexer();
        ClassInfo generatedPojo = indexer.index(this.getClass().getClassLoader().getResourceAsStream(JandexProtoGeneratorTest.toPath(GeneratedPOJO.class)));
        ClassInfo person = indexer.index(this.getClass().getClassLoader().getResourceAsStream(JandexProtoGeneratorTest.toPath(Person.class)));
        ClassInfo address = indexer.index(this.getClass().getClassLoader().getResourceAsStream(JandexProtoGeneratorTest.toPath(Address.class)));
        Index index = indexer.complete();
        JandexProtoGenerator emptyGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder((IndexView)index, null, null).build(null);
        Assertions.assertNull((Object)emptyGenerator.getPersistenceClass());
        Assertions.assertTrue((boolean)emptyGenerator.getDataClasses().isEmpty());
        Assertions.assertTrue((boolean)emptyGenerator.getModelClasses().isEmpty());
        JandexProtoGenerator persistenceClassGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder((IndexView)index, null, null).withPersistenceClass((Object)person).build(null);
        Assertions.assertEquals((Object)person, (Object)persistenceClassGenerator.getPersistenceClass());
        Assertions.assertTrue((boolean)persistenceClassGenerator.getDataClasses().isEmpty());
        Assertions.assertTrue((boolean)persistenceClassGenerator.getModelClasses().isEmpty());
        JandexProtoGenerator dataClassGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder((IndexView)index, null, null).withDataClasses(Collections.singleton(person)).build(null);
        Assertions.assertNull((Object)dataClassGenerator.getPersistenceClass());
        Assertions.assertEquals((int)1, (int)dataClassGenerator.getDataClasses().size());
        Assertions.assertTrue((boolean)dataClassGenerator.getModelClasses().isEmpty());
        JandexProtoGenerator modelClassGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder((IndexView)index, null, null).build(Collections.singleton(generatedPojo));
        Assertions.assertNull((Object)modelClassGenerator.getPersistenceClass());
        Assertions.assertEquals((int)1, (int)modelClassGenerator.getDataClasses().size());
        Assertions.assertEquals((int)1, (int)modelClassGenerator.getModelClasses().size());
        JandexProtoGenerator dataClassAndModelClassGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder((IndexView)index, null, null).withDataClasses(Arrays.asList(person, address)).build(Collections.singleton(generatedPojo));
        Assertions.assertNull((Object)dataClassAndModelClassGenerator.getPersistenceClass());
        Assertions.assertEquals((int)2, (int)dataClassAndModelClassGenerator.getDataClasses().size());
        Assertions.assertEquals((int)1, (int)dataClassAndModelClassGenerator.getModelClasses().size());
    }

    @Test
    void persistenceClassParams() throws IOException {
        Indexer indexer = new Indexer();
        JandexProtoGenerator noPersistenceClassGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(null, null, null).withPersistenceClass(null).build(null);
        Assertions.assertTrue((boolean)noPersistenceClassGenerator.getPersistenceClassParams().isEmpty());
        ClassInfo emptyConstructor = indexer.index(this.getClass().getClassLoader().getResourceAsStream(JandexProtoGeneratorTest.toPath(EmptyConstructor.class)));
        JandexProtoGenerator emptyGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(null, null, null).withPersistenceClass((Object)emptyConstructor).build(null);
        Assertions.assertTrue((boolean)emptyGenerator.getPersistenceClassParams().isEmpty());
        ClassInfo notEmptyConstructor = indexer.index(this.getClass().getClassLoader().getResourceAsStream(JandexProtoGeneratorTest.toPath(NotEmptyConstructor.class)));
        JandexProtoGenerator notEmptyGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(null, null, null).withPersistenceClass((Object)notEmptyConstructor).build(null);
        Collection notEmptyClassParams = notEmptyGenerator.getPersistenceClassParams();
        Assertions.assertFalse((boolean)notEmptyClassParams.isEmpty());
        Assertions.assertEquals((int)2, (int)notEmptyClassParams.size());
        Assertions.assertEquals(Arrays.asList(String.class.getCanonicalName(), Integer.TYPE.getCanonicalName()), (Object)notEmptyClassParams);
    }

    private static String toPath(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '/') + ".class";
    }
}

