/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.junit.jupiter.api.BeforeAll;
import org.kie.kogito.codegen.process.persistence.proto.AbstractProtoGeneratorTest;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.quarkus.processes.deployment.JandexProtoGenerator;

class JandexProtoGeneratorTest
extends AbstractProtoGeneratorTest<ClassInfo> {
    protected static Index indexWithAllClass;

    JandexProtoGeneratorTest() {
    }

    @BeforeAll
    protected static void indexOfTestClasses() {
        Indexer indexer = new Indexer();
        testClasses.forEach(clazz -> JandexProtoGeneratorTest.indexClass(indexer, clazz));
        indexWithAllClass = indexer.complete();
    }

    protected ProtoGenerator.Builder<ClassInfo, JandexProtoGenerator> protoGeneratorBuilder() {
        return JandexProtoGenerator.builder((IndexView)indexWithAllClass);
    }

    protected ClassInfo convertToType(Class<?> clazz) {
        return Optional.ofNullable(indexWithAllClass.getClassByName(DotName.createSimple((String)clazz.getCanonicalName()))).orElseThrow(() -> new IllegalStateException("Class " + clazz.getCanonicalName() + " not found in the index, add the class to AbstractProtoGeneratorTest.testClasses collection"));
    }

    private static ClassInfo indexClass(Indexer indexer, Class<?> toIndex) {
        try {
            return indexer.index(Objects.requireNonNull(JandexProtoGenerator.class.getClassLoader().getResourceAsStream(JandexProtoGeneratorTest.toPath(toIndex))));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String toPath(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '/') + ".class";
    }
}

