/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.drl.quarkus.util.deployment.DroolsQuarkusResourceUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.kie.kogito.Model;
import org.kie.kogito.ProcessInput;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;
import org.kie.kogito.codegen.process.ProcessContainerGenerator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.core.process.incubation.quarkus.support.QuarkusHumanTaskService;
import org.kie.kogito.core.process.incubation.quarkus.support.QuarkusProcessIdFactory;
import org.kie.kogito.core.process.incubation.quarkus.support.QuarkusStatefulProcessService;
import org.kie.kogito.core.process.incubation.quarkus.support.QuarkusStraightThroughProcessService;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.SimpleCorrelation;
import org.kie.kogito.event.process.AttachmentEventBody;
import org.kie.kogito.event.process.CommentEventBody;
import org.kie.kogito.event.process.MilestoneEventBody;
import org.kie.kogito.event.process.NodeInstanceEventBody;
import org.kie.kogito.event.process.ProcessDataEvent;
import org.kie.kogito.event.process.ProcessErrorEventBody;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.event.process.UserTaskDeadlineDataEvent;
import org.kie.kogito.event.process.UserTaskDeadlineEventBody;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceEventBody;
import org.kie.kogito.event.process.VariableInstanceDataEvent;
import org.kie.kogito.event.process.VariableInstanceEventBody;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoProcessContainerGeneratorBuildItem;
import org.kie.kogito.quarkus.processes.KogitoBeanProducer;
import org.kie.kogito.quarkus.processes.deployment.InMemoryClassLoader;
import org.kie.kogito.quarkus.processes.deployment.JandexMarshallerGenerator;
import org.kie.kogito.quarkus.processes.deployment.JandexProtoGenerator;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoProcessInstanceProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoTypesProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoWorkItemsProtobuf;

public class ProcessesAssetsProcessor {
    private static final DotName persistenceFactoryClass = DotName.createSimple((String)"org.kie.kogito.persistence.KogitoProcessInstancesFactory");
    private static final String PROCESS_SVG_SERVICE = "org.kie.kogito.svg.service.QuarkusProcessSvgService";
    private static final String PERSISTENCE_CAPABILITY = "org.kie.kogito.addons.persistence";
    private static final PathMatcher svgFileMatcher = FileSystems.getDefault().getPathMatcher("glob:**.svg");
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito-processes");
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void addProtoDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServiceProviderBuildItem> serviceProviderBuildItemBuildProducer, Capabilities capabilities) {
        if (capabilities.isCapabilityWithPrefixPresent(PERSISTENCE_CAPABILITY)) {
            indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.google.protobuf", "protobuf-java"));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.persistence.ProtostreamObjectMarshaller"}));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + ObjectMarshallerStrategy.class.getName()}));
            serviceProviderBuildItemBuildProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ObjectMarshallerStrategy.class.getName()));
            this.addInnerClasses(KogitoProcessInstanceProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoTypesProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoNodeInstanceContentsProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoWorkItemsProtobuf.class, reflectiveHierarchyClass);
        }
    }

    @BuildStep
    public ReflectiveClassBuildItem reflectionProcess(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"org.kogito.workitem.rest.decorators.RequestDecorator"));
        return new ReflectiveClassBuildItem(true, true, new String[]{"org.kogito.workitem.rest.bodybuilders.ParamsRestWorkItemHandlerBodyBuilder", "org.kogito.workitem.rest.decorators.CollectionParamsDecorator", "org.kogito.workitem.rest.auth.ClientOAuth2AuthDecorator", "org.kogito.workitem.rest.auth.PasswordOAuth2AuthDecorator", "io.vertx.core.http.HttpMethod", "org.kie.kogito.process.impl.BaseWorkItem", "org.kie.kogito.event.Topic", "org.kie.kogito.event.cloudevents.CloudEventMeta", "org.kie.kogito.event.cloudevents.SpecVersionDeserializer", "org.kie.kogito.event.cloudevents.SpecVersionSerializer", "org.kie.kogito.jobs.api.Job", CompositeCorrelation.class.getCanonicalName(), SimpleCorrelation.class.getCanonicalName(), Correlation.class.getCanonicalName(), CorrelationInstance.class.getCanonicalName(), ExceptionScope.class.getCanonicalName()});
    }

    @BuildStep
    public ReflectiveClassBuildItem eventsApiReflection() {
        return new ReflectiveClassBuildItem(true, true, new String[]{AttachmentEventBody.class.getName(), CommentEventBody.class.getName(), MilestoneEventBody.class.getName(), NodeInstanceEventBody.class.getName(), ProcessDataEvent.class.getName(), ProcessErrorEventBody.class.getName(), ProcessInstanceDataEvent.class.getName(), ProcessInstanceEventBody.class.getName(), UserTaskDeadlineDataEvent.class.getName(), UserTaskDeadlineEventBody.class.getName(), UserTaskInstanceDataEvent.class.getName(), UserTaskInstanceEventBody.class.getName(), VariableInstanceDataEvent.class.getName(), VariableInstanceEventBody.class.getName()});
    }

    @BuildStep
    public AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{QuarkusStraightThroughProcessService.class, QuarkusStatefulProcessService.class, QuarkusHumanTaskService.class, QuarkusProcessIdFactory.class, KogitoBeanProducer.class}).build();
    }

    @BuildStep
    public void processApplicationSection(KogitoBuildContextBuildItem kogitoBuildContextBuildItem, BuildProducer<KogitoProcessContainerGeneratorBuildItem> processContainerProducer, KogitoGeneratedSourcesBuildItem generatedKogitoClasses) {
        KogitoProcessContainerGeneratorBuildItem buildItem = new KogitoProcessContainerGeneratorBuildItem(kogitoBuildContextBuildItem.getKogitoBuildContext().getApplicationSections().stream().filter(ProcessContainerGenerator.class::isInstance).map(ProcessContainerGenerator.class::cast).collect(Collectors.toSet()));
        if (!buildItem.getProcessContainerGenerators().isEmpty()) {
            processContainerProducer.produce((BuildItem)buildItem);
        }
    }

    @BuildStep
    public void postGenerationProcessing(List<KogitoGeneratedClassesBuildItem> generatedKogitoClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalStaticResourceBuildItem> staticResProducer, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatterns, BuildProducer<GeneratedResourceBuildItem> genResBI, CombinedIndexBuildItem combinedIndexBuildItem, KogitoBuildContextBuildItem kogitoBuildContextBuildItem, Capabilities capabilities) throws IOException {
        IndexView aggregatedIndex = KogitoQuarkusResourceUtils.generateAggregatedIndex((IndexView)combinedIndexBuildItem.getComputingIndex(), generatedKogitoClasses);
        KogitoBuildContext context = kogitoBuildContextBuildItem.getKogitoBuildContext();
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        if (capabilities.isCapabilityWithPrefixPresent(PERSISTENCE_CAPABILITY)) {
            generatedFiles.addAll(this.generatePersistenceInfo(context, aggregatedIndex, generatedBeans, resourcePatterns, this.liveReload.isLiveReload()));
        }
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (KogitoGeneratedClassesBuildItem generatedKogitoClass : generatedKogitoClasses) {
            classes.putAll(generatedKogitoClass.getGeneratedClasses());
        }
        generatedFiles.addAll(this.generateJsonSchema(context, aggregatedIndex, classes));
        KogitoQuarkusResourceUtils.dumpFilesToDisk((AppPaths)context.getAppPaths(), generatedFiles);
        KogitoQuarkusResourceUtils.registerResources(generatedFiles, staticResProducer, resource, genResBI);
        this.registerProcessSVG(context, resource);
    }

    private Collection<GeneratedFile> generatePersistenceInfo(KogitoBuildContext context, IndexView index, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatterns, boolean useDebugSymbols) throws IOException {
        Collection<GeneratedFile> persistenceGeneratedFiles = this.getGeneratedPersistenceFiles(index, context, resourcePatterns);
        GeneratedFileValidation.validateGeneratedFileTypes(persistenceGeneratedFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.INTERNAL_RESOURCE, GeneratedFileType.Category.STATIC_HTTP_RESOURCE));
        Collection dependencies = this.curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        DroolsQuarkusResourceUtils.compileGeneratedSources((DroolsModelBuildContext)context, (Collection)dependencies, persistenceGeneratedFiles, (boolean)useDebugSymbols).forEach(arg_0 -> generatedBeans.produce(arg_0));
        return persistenceGeneratedFiles;
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(IndexView index, KogitoBuildContext context, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatterns) {
        Collection modelClasses = index.getAllKnownImplementors(DotName.createSimple((String)Model.class.getCanonicalName()));
        JandexProtoGenerator protoGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(index).build(modelClasses);
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator, (MarshallerGenerator)new JandexMarshallerGenerator(context, modelClasses));
        return persistenceGenerator.generate();
    }

    private void addInnerClasses(Class<?> superClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass) {
        DotName dotName = DotName.createSimple((String)superClass.getName());
        Type type = Type.create((DotName)dotName, (Type.Kind)Type.Kind.CLASS);
        reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).build());
        Arrays.asList(superClass.getDeclaredClasses()).forEach(c -> this.addInnerClasses((Class<?>)c, reflectiveHierarchyClass));
    }

    private void registerProcessSVG(KogitoBuildContext context, BuildProducer<NativeImageResourceBuildItem> resource) throws IOException {
        if (!context.hasClassAvailable(PROCESS_SVG_SERVICE)) {
            return;
        }
        Path relativePath = Paths.get("META-INF", "processSVG");
        Path targetClasses = KogitoQuarkusResourceUtils.getTargetClassesPath((AppPaths)context.getAppPaths());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"org/apache/batik/util/resources/XMLResourceDescriptor.properties"}));
        Path resolvedPath = targetClasses.resolve(relativePath);
        try (Stream<Path> filePathFound = Files.find(resolvedPath, Integer.MAX_VALUE, (filePath, attrs) -> svgFileMatcher.matches((Path)filePath), new FileVisitOption[0]);){
            List svgs = filePathFound.map(svgPath -> targetClasses.relativize((Path)svgPath).toString()).collect(Collectors.toList());
            resource.produce((BuildItem)new NativeImageResourceBuildItem(svgs));
        }
    }

    private Collection<GeneratedFile> generateJsonSchema(KogitoBuildContext context, IndexView index, Map<String, byte[]> generatedClasses) throws IOException {
        InMemoryClassLoader cl = new InMemoryClassLoader(context.getClassLoader(), generatedClasses);
        ArrayList annotations = new ArrayList();
        annotations.addAll(index.getAnnotations(DotName.createSimple((String)ProcessInput.class.getCanonicalName())));
        annotations.addAll(index.getAnnotations(DotName.createSimple((String)UserTask.class.getCanonicalName())));
        List annotatedClasses = annotations.stream().map(ann -> this.loadClassFromAnnotation((AnnotationInstance)ann, cl)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator.ClassBuilder(annotatedClasses.stream()).withSchemaVersion(System.getProperty("kogito.jsonSchema.version")).build();
        return jsonSchemaGenerator.generate();
    }

    private Optional<Class<?>> loadClassFromAnnotation(AnnotationInstance annotationInstance, ClassLoader classLoader) {
        try {
            return Optional.of(classLoader.loadClass(annotationInstance.target().asClass().name().toString()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

