/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.kie.kogito.codegen.data.Address;
import org.kie.kogito.codegen.data.Answer;
import org.kie.kogito.codegen.data.AnswerBroken;
import org.kie.kogito.codegen.data.AnswerBrokenV2;
import org.kie.kogito.codegen.data.AnswerWithAnnotations;
import org.kie.kogito.codegen.data.EmptyConstructor;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.data.Hello;
import org.kie.kogito.codegen.data.HelloModel;
import org.kie.kogito.codegen.data.JacksonData;
import org.kie.kogito.codegen.data.ListWithoutType;
import org.kie.kogito.codegen.data.NotEmptyConstructor;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonSubClass;
import org.kie.kogito.codegen.data.PersonVarInfo;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.data.PersonWithList;
import org.kie.kogito.codegen.data.Question;
import org.kie.kogito.codegen.data.QuestionWithAnnotatedEnum;
import org.kie.kogito.codegen.data.Travels;
import org.kie.kogito.quarkus.processes.deployment.JandexProtoGenerator;

public final class JandexTestUtils {
    protected static Collection<Class<?>> testClasses = Arrays.asList(Address.class, Answer.class, AnswerWithAnnotations.class, AnswerBroken.class, AnswerBrokenV2.class, EmptyConstructor.class, GeneratedPOJO.class, Hello.class, HelloModel.class, NotEmptyConstructor.class, Person.class, PersonVarInfo.class, PersonWithAddress.class, PersonWithAddresses.class, PersonWithList.class, Question.class, QuestionWithAnnotatedEnum.class, Travels.class, PersonSubClass.class, JacksonData.class, ListWithoutType.class);

    private JandexTestUtils() {
    }

    private static ClassInfo indexClass(Indexer indexer, Class<?> toIndex) {
        try {
            return indexer.index(Objects.requireNonNull(JandexProtoGenerator.class.getClassLoader().getResourceAsStream(JandexTestUtils.toPath(toIndex))));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String toPath(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '/') + ".class";
    }

    public static Index createTestIndex() {
        Indexer indexer = new Indexer();
        testClasses.forEach(clazz -> JandexTestUtils.indexClass(indexer, clazz));
        return indexer.complete();
    }

    public static ClassInfo findClassInfo(Index index, Class<?> clazz) {
        return Optional.ofNullable(index.getClassByName(DotName.createSimple((String)clazz.getCanonicalName()))).orElseThrow(() -> new IllegalStateException("Class " + clazz.getCanonicalName() + " not found in the index, add the class to JandexTestUtils.testClasses collection"));
    }
}

