/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kie.kogito.quarkus.common.deployment.KogitoDataIndexServiceAvailableBuildItem;
import org.kie.kogito.quarkus.processes.deployment.KogitoBuildTimeConfig;
import org.kie.kogito.quarkus.processes.deployment.KogitoDevServicesBuildTimeConfig;
import org.kie.kogito.quarkus.processes.devservices.DataIndexEventPublisher;
import org.kie.kogito.quarkus.processes.devservices.DataIndexInMemoryContainer;
import org.kie.kogito.quarkus.processes.devservices.DevModeWorkflowLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.Testcontainers;
import org.testcontainers.utility.DockerImageName;

public class KogitoDevServicesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoDevServicesProcessor.class);
    private static final ContainerLocator LOCATOR = new ContainerLocator("kogito-dev-service-data-index", 8080);
    private static final Map<String, Properties> DEVSERVICES_PROPS = new ConcurrentHashMap<String, Properties>();
    static volatile Closeable closeable;
    static volatile DataIndexDevServiceConfig cfg;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep
    public void logger(BuildProducer<AdditionalBeanBuildItem> additionalBean, LaunchModeBuildItem launchMode, KogitoBuildTimeConfig config, Capabilities capabilities) {
        if (KogitoDevServicesProcessor.shouldInclude(launchMode, config, capabilities)) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(DevModeWorkflowLogger.class).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
        }
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, KogitoBuildTimeConfig config, Capabilities capabilities) {
        return capabilities.isMissing("org.kie.kogito.serverless-workflow") && (launchMode.getLaunchMode().isDevOrTest() || config.alwaysInclude);
    }

    private static String getDataIndexImageVersion() {
        Package aPackage = KogitoDevServicesProcessor.class.getPackage();
        String version = null;
        if (aPackage != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            return "latest";
        }
        DefaultArtifactVersion av = new DefaultArtifactVersion(version);
        if ("SNAPSHOT".equals(av.getQualifier())) {
            return "latest";
        }
        return av.getMajorVersion() + "." + av.getMinorVersion();
    }

    @BuildStep(onlyIf={GlobalDevServicesConfig.Enabled.class, IsDevelopment.class})
    public void startDataIndexDevService(BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<KogitoDataIndexServiceAvailableBuildItem> dataIndexServiceAvailableBuildItemBuildProducer, LaunchModeBuildItem launchMode, KogitoBuildTimeConfig buildTimeConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetwork, Optional<ConsoleInstalledBuildItem> consoleInstalled, CuratedApplicationShutdownBuildItem applicationShutdown, LoggingSetupBuildItem loggingSetup) {
        DataIndexInstance dataIndex;
        DataIndexDevServiceConfig configuration = this.getConfiguration(buildTimeConfig);
        if (configuration.devServicesEnabled && this.isDockerWorking.getAsBoolean()) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(DataIndexEventPublisher.class).build());
            Integer port = ConfigProvider.getConfig().getOptionalValue("quarkus.http.port", Integer.class).orElse(8080);
            Testcontainers.exposeHostPorts((int[])new int[]{port});
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("kogito.service.url", "http://localhost:" + port));
        }
        LOGGER.info("Dev Services for Kogito Data Index using image {}", (Object)configuration.imageName);
        if (closeable != null) {
            boolean shouldShutdown;
            boolean bl = shouldShutdown = !configuration.equals(cfg);
            if (!shouldShutdown) {
                dataIndexServiceAvailableBuildItemBuildProducer.produce((BuildItem)new KogitoDataIndexServiceAvailableBuildItem());
                return;
            }
            this.shutdownDataIndex();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Kogito Data Index Dev Service starting:", consoleInstalled, loggingSetup);
        try {
            dataIndex = this.startDataIndex(configuration, launchMode, !devServicesSharedNetwork.isEmpty());
            if (dataIndex != null) {
                dataIndexServiceAvailableBuildItemBuildProducer.produce((BuildItem)new KogitoDataIndexServiceAvailableBuildItem());
                closeable = dataIndex.getCloseable();
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("kogito.data-index.url", dataIndex.getUrl()));
            }
            compressor.close();
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException("Failed to start Kogito Data Index Dev Services", t);
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (closeable != null) {
                    this.shutdownDataIndex();
                }
                first = true;
                closeable = null;
                cfg = null;
            };
            applicationShutdown.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (dataIndex != null && dataIndex.isOwner()) {
            LOGGER.info("Dev Services for Kogito Data Index started at {}", (Object)dataIndex.getUrl());
        }
    }

    private void shutdownDataIndex() {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to stop Kogito Data Index", e);
            }
            finally {
                closeable = null;
            }
        }
    }

    private DataIndexInstance startDataIndex(DataIndexDevServiceConfig config, LaunchModeBuildItem launchMode, boolean useSharedNetwork) {
        if (!config.devServicesEnabled) {
            LOGGER.debug("Not starting dev services for Kogito, as it has been disabled in the config.");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            LOGGER.warn("Docker isn't working, unable to start Data Index image.");
            return null;
        }
        Optional maybeContainerAddress = LOCATOR.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<DataIndexInstance> dataIndexSupplier = () -> {
            try {
                DataIndexInMemoryContainer container = new DataIndexInMemoryContainer(config.imageName, config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork);
                container.start();
                return new DataIndexInstance(container.getUrl(), () -> ((DataIndexInMemoryContainer)container).close());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        return maybeContainerAddress.map(containerAddress -> new DataIndexInstance(containerAddress.getUrl(), null)).orElseGet(dataIndexSupplier);
    }

    private DataIndexDevServiceConfig getConfiguration(KogitoBuildTimeConfig cfg) {
        KogitoDevServicesBuildTimeConfig devServicesConfig = cfg.devservices;
        return new DataIndexDevServiceConfig(devServicesConfig);
    }

    private static String getDefaultImageNameFor(String devserviceName) {
        String imageName = DEVSERVICES_PROPS.computeIfAbsent(devserviceName, KogitoDevServicesProcessor::loadProperties).getProperty("default.image");
        if (imageName == null) {
            throw new IllegalArgumentException("No default.image configured for " + devserviceName);
        }
        return imageName;
    }

    private static Properties loadProperties(String devserviceName) {
        Properties properties;
        block9: {
            String fileName = devserviceName + "-devservice.properties";
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            try {
                if (in == null) {
                    throw new IllegalArgumentException(fileName + " not found on classpath");
                }
                Properties properties2 = new Properties();
                properties2.load(in);
                properties = properties2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return properties;
    }

    static {
        first = true;
    }

    private static final class DataIndexDevServiceConfig {
        private static final String PLACEHOLDER = "{placeholder}";
        private final boolean devServicesEnabled;
        private final DockerImageName imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;

        public DataIndexDevServiceConfig(KogitoDevServicesBuildTimeConfig config) {
            this.devServicesEnabled = config.enabled.orElse(true);
            this.imageName = config.imageName.map(DockerImageName::parse).orElseGet(() -> {
                String defaultImageName = KogitoDevServicesProcessor.getDefaultImageNameFor("data-index");
                DockerImageName dockerImageName = DockerImageName.parse((String)defaultImageName);
                if (PLACEHOLDER.equals(dockerImageName.getVersionPart())) {
                    dockerImageName = DockerImageName.parse((String)(dockerImageName.getUnversionedPart() + ":" + KogitoDevServicesProcessor.getDataIndexImageVersion()));
                }
                return dockerImageName;
            });
            this.imageName.assertValid();
            this.fixedExposedPort = config.port.orElse(0);
            this.shared = config.shared;
            this.serviceName = config.serviceName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataIndexDevServiceConfig that = (DataIndexDevServiceConfig)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }

    private static class DataIndexInstance {
        private final String url;
        private final Closeable closeable;

        public DataIndexInstance(String url, Closeable closeable) {
            this.url = url;
            this.closeable = closeable;
        }

        public boolean isOwner() {
            return this.closeable != null;
        }

        public String getUrl() {
            return this.url;
        }

        public Closeable getCloseable() {
            return this.closeable;
        }
    }
}

