/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.common.deployment;

import io.quarkus.deployment.Capabilities;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.quarkus.common.deployment.KogitoAssetsProcessor;
import org.kie.kogito.quarkus.common.deployment.MissingRestCapabilityException;

class KogitoAssetsProcessorTest {
    KogitoAssetsProcessorTest() {
    }

    @Test
    public void validateAvailableCapabilitiesWithOptaPlannerNoRest() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().build();
        Capabilities capabilities = this.capabilities("org.optaplanner.optaplanner-quarkus");
        KogitoAssetsProcessor processor = new KogitoAssetsProcessor();
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).isEmpty();
        processor.validateAvailableCapabilities(context, capabilities);
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).contains((Object)"false");
    }

    @Test
    public void validateAvailableCapabilitiesWithOptaPlannerWithRest() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().build();
        Capabilities capabilities = this.capabilities("io.quarkus.resteasy", "io.quarkus.resteasy.json.jackson", "org.optaplanner.optaplanner-quarkus");
        KogitoAssetsProcessor processor = new KogitoAssetsProcessor();
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).isEmpty();
        processor.validateAvailableCapabilities(context, capabilities);
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).isEmpty();
    }

    @Test
    public void validateAvailableCapabilitiesWithoutOptaPlanner() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().build();
        Capabilities capabilities = this.capabilities("io.quarkus.resteasy", "io.quarkus.resteasy.json.jackson");
        KogitoAssetsProcessor processor = new KogitoAssetsProcessor();
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).isEmpty();
        processor.validateAvailableCapabilities(context, capabilities);
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).isEmpty();
    }

    @Test
    public void validateAvailableCapabilitiesRest() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().build();
        KogitoAssetsProcessor processor = new KogitoAssetsProcessor();
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).isEmpty();
        Assertions.assertThatThrownBy(() -> processor.validateAvailableCapabilities(context, this.capabilities(new String[0]))).isInstanceOf(MissingRestCapabilityException.class);
        Assertions.assertThatThrownBy(() -> processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy"))).isInstanceOf(MissingRestCapabilityException.class);
        Assertions.assertThatThrownBy(() -> processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.json.jackson"))).isInstanceOf(MissingRestCapabilityException.class);
        Assertions.assertThatThrownBy(() -> processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.reactive"))).isInstanceOf(MissingRestCapabilityException.class);
        Assertions.assertThatThrownBy(() -> processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.reactive.json.jackson"))).isInstanceOf(MissingRestCapabilityException.class);
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy", "io.quarkus.resteasy.json.jackson"));
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.reactive", "io.quarkus.resteasy.reactive.json.jackson"));
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).isEmpty();
    }

    @Test
    public void validateAvailableCapabilitiesRestDisabled() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().build();
        context.setApplicationProperty("kogito.generate.rest", "false");
        KogitoAssetsProcessor processor = new KogitoAssetsProcessor();
        processor.validateAvailableCapabilities(context, this.capabilities(new String[0]));
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy"));
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.json.jackson"));
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy", "io.quarkus.resteasy.json.jackson"));
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.reactive"));
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.reactive.json.jackson"));
        processor.validateAvailableCapabilities(context, this.capabilities("io.quarkus.resteasy.reactive", "io.quarkus.resteasy.reactive.json.jackson"));
        Assertions.assertThat((Optional)context.getApplicationProperty("kogito.generate.rest")).contains((Object)"false");
    }

    private Capabilities capabilities(String ... values) {
        return new Capabilities(Set.of(values));
    }
}

