/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import com.example.Payload;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.application.AppRoot;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.EmptyDataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessIds;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.TaskInstanceId;
import org.kie.kogito.incubation.processes.services.StatefulProcessService;
import org.kie.kogito.incubation.processes.services.contexts.Policy;
import org.kie.kogito.incubation.processes.services.contexts.ProcessMetaDataContext;
import org.kie.kogito.incubation.processes.services.contexts.TaskMetaDataContext;
import org.kie.kogito.incubation.processes.services.contexts.TaskWorkItemDataContext;
import org.kie.kogito.incubation.processes.services.humantask.HumanTaskService;

@QuarkusTest
public class StatefulProcessResourceTest {
    String body = "{\n    \"traveller\" : {\n        \"firstName\" : \"John\",\n        \"lastName\" : \"Doe\",\n        \"email\" : \"jon.doe@example.com\",\n        \"nationality\" : \"American\",\n        \"address\" : {\n          \t\"street\" : \"main street\",\n          \t\"city\" : \"Boston\",\n          \t\"zipCode\" : \"10005\",\n          \t\"country\" : \"US\"\n        }\n    }\n}\n";
    @Inject
    AppRoot appRoot;
    @Inject
    StatefulProcessService processSvc;
    @Inject
    HumanTaskService taskSvc;
    @Inject
    ObjectMapper mapper;

    @Test
    public void createProcess() throws JsonProcessingException {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("approvals");
        MapDataContext ctx = (MapDataContext)this.mapper.readValue(this.body, MapDataContext.class);
        ExtendedDataContext approvalsCreated = this.processSvc.create((LocalId)id, (DataContext)ctx);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)approvalsCreated.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        MapDataContext data = (MapDataContext)approvalsCreated.data().as(MapDataContext.class);
        Assertions.assertEquals((Object)id, (Object)pid.processId());
        Assertions.assertNull((Object)data.get("approver"));
    }

    @Test
    public void getProcess() throws JsonProcessingException {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("approvals");
        MapDataContext ctx = (MapDataContext)this.mapper.readValue(this.body, MapDataContext.class);
        ExtendedDataContext approvalsCreated = this.processSvc.create((LocalId)id, (DataContext)ctx);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)approvalsCreated.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        Assertions.assertEquals((Object)id, (Object)pid.processId());
        ExtendedDataContext result = this.processSvc.get((LocalId)pid);
        MapDataContext data = (MapDataContext)result.data().as(MapDataContext.class);
        Assertions.assertNull((Object)data.get("approver"));
    }

    @Test
    public void updateProcess() throws JsonProcessingException {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("approvals");
        MapDataContext ctx = (MapDataContext)this.mapper.readValue(this.body, MapDataContext.class);
        ExtendedDataContext approvalsCreated = this.processSvc.create((LocalId)id, (DataContext)ctx);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)approvalsCreated.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        MapDataContext data = (MapDataContext)approvalsCreated.data().as(MapDataContext.class);
        Assertions.assertEquals((Object)id, (Object)pid.processId());
        Assertions.assertNull((Object)data.get("approver"));
        MapDataContext traveller = (MapDataContext)ctx.get("traveller", MapDataContext.class);
        traveller.set("firstName", (Object)"Josh");
        ctx.set("traveller", (Object)traveller);
        ExtendedDataContext updatedResult = this.processSvc.update((LocalId)pid, (DataContext)ctx);
        Assertions.assertEquals((Object)"Josh", (Object)((MapDataContext)((MapDataContext)updatedResult.data().as(MapDataContext.class)).get("traveller", MapDataContext.class)).get("firstName"));
    }

    @Test
    public void abortProcess() throws JsonProcessingException {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("approvals");
        MapDataContext ctx = (MapDataContext)this.mapper.readValue(this.body, MapDataContext.class);
        ExtendedDataContext approvalsCreated = this.processSvc.create((LocalId)id, (DataContext)ctx);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)approvalsCreated.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        ExtendedDataContext result = this.processSvc.abort((LocalId)pid);
        Assertions.assertNull((Object)((MapDataContext)result.data().as(MapDataContext.class)).get("approver"));
    }

    @Test
    public void completeTask() throws JsonProcessingException {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("approvals");
        MapDataContext ctx = (MapDataContext)this.mapper.readValue(this.body, MapDataContext.class);
        ExtendedDataContext approvalsCreated = this.processSvc.create((LocalId)id, (DataContext)ctx);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)approvalsCreated.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        TaskMetaDataContext taskMeta = TaskMetaDataContext.of((Policy)Policy.of((String)"admin", List.of("managers")));
        ExtendedDataContext tasks = this.taskSvc.get((LocalId)pid.tasks(), (MetaDataContext)taskMeta);
        List taskIdList = ((TaskWorkItemDataContext)tasks.meta().as(TaskWorkItemDataContext.class)).tasks();
        Assertions.assertEquals((int)1, (int)taskIdList.size());
        TaskInstanceId taskId = (TaskInstanceId)taskIdList.get(0);
        ExtendedDataContext result = this.taskSvc.complete((LocalId)taskId, (DataContext)ExtendedDataContext.of((MetaDataContext)taskMeta, (DataContext)MapDataContext.of(Map.of("some", "value"))));
        Assertions.assertEquals((Object)taskMeta.policy().user(), (Object)((MapDataContext)result.data().as(MapDataContext.class)).get("approver"));
    }

    @Test
    public void completeProcess() throws JsonProcessingException {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("approvals");
        MapDataContext ctx = (MapDataContext)this.mapper.readValue(this.body, MapDataContext.class);
        ExtendedDataContext approvalsCreated = this.processSvc.create((LocalId)id, (DataContext)ctx);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)approvalsCreated.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        TaskMetaDataContext taskMeta = TaskMetaDataContext.of((Policy)Policy.of((String)"admin", List.of("managers")));
        ExtendedDataContext tasks = this.taskSvc.get((LocalId)pid.tasks(), (MetaDataContext)taskMeta);
        List taskIdList = ((TaskWorkItemDataContext)tasks.meta().as(TaskWorkItemDataContext.class)).tasks();
        Assertions.assertEquals((int)1, (int)taskIdList.size());
        TaskInstanceId taskId = (TaskInstanceId)taskIdList.get(0);
        ExtendedDataContext result = this.taskSvc.complete((LocalId)taskId, (DataContext)ExtendedDataContext.of((MetaDataContext)taskMeta, (DataContext)MapDataContext.of(Map.of("some", "value"))));
        Assertions.assertEquals((Object)taskMeta.policy().user(), (Object)((MapDataContext)result.data().as(MapDataContext.class)).get("approver"));
        taskMeta = TaskMetaDataContext.of((Policy)Policy.of((String)"john", List.of("managers")));
        tasks = this.taskSvc.get((LocalId)pid.tasks(), (MetaDataContext)taskMeta);
        taskIdList = ((TaskWorkItemDataContext)tasks.meta().as(TaskWorkItemDataContext.class)).tasks();
        Assertions.assertEquals((int)1, (int)taskIdList.size());
        taskId = (TaskInstanceId)taskIdList.get(0);
        result = this.taskSvc.complete((LocalId)taskId, (DataContext)ExtendedDataContext.of((MetaDataContext)taskMeta, (DataContext)MapDataContext.of(Map.of("some", "value"))));
        Assertions.assertEquals((Object)"admin", (Object)((MapDataContext)result.data().as(MapDataContext.class)).get("approver"));
    }

    @Test
    public void signalTaskProcess() {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("flexible");
        MapDataContext dc = MapDataContext.create();
        Payload payload = new Payload();
        payload.setValue("started");
        dc.set("test", (Object)payload);
        ExtendedDataContext created = this.processSvc.create((LocalId)id, (DataContext)dc);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)created.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        Assertions.assertEquals((Object)"started", (Object)((Payload)((MapDataContext)created.data().as(MapDataContext.class)).get("test", Payload.class)).getValue());
        ExtendedDataContext taskCreated = this.taskSvc.create((LocalId)pid.tasks().get("InitialTask"));
        String tid = (String)((MapDataContext)taskCreated.data().as(MapDataContext.class)).get("id", String.class);
        TaskInstanceId taskInstanceId = pid.tasks().get("InitialTask").instances().get(tid);
        ExtendedDataContext result = this.taskSvc.complete((LocalId)taskInstanceId, EmptyDataContext.Instance);
        Assertions.assertEquals((Object)"ad-hoc", (Object)((Payload)((MapDataContext)result.data().as(MapDataContext.class)).get("test", Payload.class)).getValue());
    }

    @Test
    public void completeProcessTask() {
        LocalProcessId id = ((ProcessIds)this.appRoot.get(ProcessIds.class)).get("signal");
        MapDataContext dc = MapDataContext.create();
        Payload payload = new Payload();
        payload.setValue("started");
        dc.set("test", (Object)payload);
        ExtendedDataContext created = this.processSvc.create((LocalId)id, (DataContext)dc);
        ProcessInstanceId pid = (ProcessInstanceId)((ProcessMetaDataContext)created.meta().as(ProcessMetaDataContext.class)).id(ProcessInstanceId.class);
        Assertions.assertEquals((Object)"started", (Object)((Payload)((MapDataContext)created.data().as(MapDataContext.class)).get("test", Payload.class)).getValue());
        ExtendedDataContext result = this.processSvc.signal((LocalId)pid.signals().get("sig"), EmptyDataContext.Instance);
        Assertions.assertEquals((Object)"done", (Object)((Payload)((MapDataContext)result.data().as(MapDataContext.class)).get("test", Payload.class)).getValue());
    }
}

