/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.process.incubation.quarkus.support;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.Model;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.Id;
import org.kie.kogito.incubation.common.InternalObjectMapper;
import org.kie.kogito.incubation.common.LocalUri;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.services.StraightThroughProcessService;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;

@ApplicationScoped
public class QuarkusStraightThroughProcessService
implements StraightThroughProcessService {
    @Inject
    Instance<Processes> processesInstance;

    public DataContext evaluate(Id processId, DataContext inputContext) {
        Processes processes = (Processes)this.processesInstance.get();
        LocalUri processPath = processId.toLocalId().asLocalUri();
        if (processPath.startsWith("processes")) {
            LocalProcessId pid = (LocalProcessId)processId;
            Process process = processes.processById(pid.processId());
            MapDataContext mdc = (MapDataContext)inputContext.as(MapDataContext.class);
            Class<?> modelType = ((Model)process.createModel()).getClass();
            Model model = (Model)InternalObjectMapper.convertValue((Object)mdc, modelType);
            ProcessInstance instance = process.createInstance(model);
            instance.start();
            Map map = ((Model)instance.variables()).toMap();
            return MapDataContext.of((Map)map);
        }
        throw new IllegalArgumentException("Not a valid processId " + processPath);
    }
}

