/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.process.incubation.quarkus.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.process.instance.impl.humantask.HumanTaskHelper;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.EmptyDataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessIdParser;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.TaskId;
import org.kie.kogito.incubation.processes.TaskIds;
import org.kie.kogito.incubation.processes.TaskInstanceId;
import org.kie.kogito.incubation.processes.services.contexts.ProcessMetaDataContext;
import org.kie.kogito.incubation.processes.services.contexts.TaskMetaDataContext;
import org.kie.kogito.incubation.processes.services.humantask.HumanTaskService;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;

class HumanTaskServiceImpl
implements HumanTaskService {
    private final Application application;
    private final ProcessService svc;
    private final Processes processes;

    HumanTaskServiceImpl(Application application, ProcessService svc, Processes processes) {
        this.application = application;
        this.svc = svc;
        this.processes = processes;
    }

    private Process<MappableToModel<Model>> parseProcess(LocalProcessId pid) {
        return this.processes.processById(pid.processId());
    }

    public ExtendedDataContext get(LocalId id, MetaDataContext meta) {
        TaskMetaDataContext metaCtx = (TaskMetaDataContext)meta.as(TaskMetaDataContext.class);
        SecurityPolicy securityPolicy = this.convertPolicyObject(metaCtx.policy());
        try {
            TaskIds taskIds = (TaskIds)ProcessIdParser.select((LocalId)id, TaskIds.class);
            ProcessInstanceId instanceId = taskIds.processInstanceId();
            Process<MappableToModel<Model>> process = this.parseProcess(instanceId.processId());
            String processInstanceIdString = instanceId.processInstanceId();
            List tasks = ((List)this.svc.getTasks(process, processInstanceIdString, securityPolicy).orElseThrow()).stream().map(wi -> taskIds.get(wi.getName()).instances().get(wi.getId()).asLocalUri().path()).collect(Collectors.toList());
            MapDataContext mdc = MapDataContext.create();
            mdc.set("tasks", tasks);
            return ExtendedDataContext.of((MetaDataContext)mdc, (DataContext)EmptyDataContext.Instance);
        }
        catch (IllegalArgumentException e) {
            TaskInstanceId taskInstanceId = (TaskInstanceId)ProcessIdParser.select((LocalId)id, TaskInstanceId.class);
            ProcessInstanceId instanceId = taskInstanceId.taskId().processInstanceId();
            Process<MappableToModel<Model>> process = this.parseProcess(instanceId.processId());
            String taskInstanceIdString = taskInstanceId.taskInstanceId();
            String processInstanceIdString = instanceId.processInstanceId();
            WorkItem workItem = (WorkItem)this.svc.getTask(process, processInstanceIdString, taskInstanceIdString, securityPolicy, Function.identity()).orElseThrow(() -> new IllegalArgumentException("Cannot find ID " + id.asLocalUri().path()));
            return ExtendedDataContext.ofData((DataContext)MapDataContext.of((Map)workItem.getResults()));
        }
    }

    public ExtendedDataContext create(LocalId id) {
        TaskId taskId = (TaskId)ProcessIdParser.select((LocalId)id, TaskId.class);
        ProcessInstanceId instanceId = taskId.processInstanceId();
        Process<MappableToModel<Model>> process = this.parseProcess(instanceId.processId());
        WorkItem workItem = (WorkItem)this.svc.signalTask(process, instanceId.processInstanceId(), taskId.taskId()).orElseThrow();
        MapDataContext dataContext = MapDataContext.from((Object)workItem);
        return ExtendedDataContext.of((MetaDataContext)ProcessMetaDataContext.of((LocalId)taskId), (DataContext)dataContext);
    }

    public ExtendedDataContext abort(LocalId id, MetaDataContext metaDataContext) {
        MapDataContext mdc = (MapDataContext)metaDataContext.as(MapDataContext.class);
        mdc.set("phase", (Object)"abort");
        return this.transition(id, (DataContext)ExtendedDataContext.of((MetaDataContext)mdc, (DataContext)EmptyDataContext.Instance));
    }

    public ExtendedDataContext complete(LocalId processId, DataContext dataContext) {
        ExtendedDataContext edc = (ExtendedDataContext)dataContext.as(ExtendedDataContext.class);
        MapDataContext mdc = (MapDataContext)edc.meta().as(MapDataContext.class);
        mdc.set("phase", (Object)"complete");
        return this.transition(processId, (DataContext)ExtendedDataContext.of((MetaDataContext)mdc, (DataContext)edc.data()));
    }

    public ExtendedDataContext transition(LocalId id, DataContext dataContext) {
        ExtendedDataContext edc = (ExtendedDataContext)dataContext.as(ExtendedDataContext.class);
        TaskMetaDataContext mdc = (TaskMetaDataContext)edc.meta().as(TaskMetaDataContext.class);
        SecurityPolicy securityPolicy = this.convertPolicyObject(mdc.policy());
        String phase = mdc.phase();
        Objects.requireNonNull(phase, "Phase must be specified");
        TaskInstanceId taskInstanceId = (TaskInstanceId)ProcessIdParser.select((LocalId)id, TaskInstanceId.class);
        TaskId taskId = taskInstanceId.taskId();
        ProcessInstanceId instanceId = taskId.processInstanceId();
        Process<MappableToModel<Model>> process = this.parseProcess(instanceId.processId());
        Collection tasks = process.findNodes(n -> n instanceof HumanTaskNode && ((HumanTaskNode)n).getWork().getParameter("TaskName").equals(taskId.taskId()));
        if (tasks.isEmpty()) {
            throw new IllegalArgumentException("No such taskId " + taskId.taskId());
        }
        String taskInstanceIdString = taskInstanceId.taskInstanceId();
        String processInstanceIdString = instanceId.processInstanceId();
        Map map = ((MapDataContext)dataContext.as(MapDataContext.class)).toMap();
        MappableToModel model = (MappableToModel)process.createModel();
        model.fromMap(map);
        Model result = (Model)this.svc.taskTransition(process, processInstanceIdString, taskInstanceIdString, phase, securityPolicy, (MapOutput)model).orElseThrow();
        return ExtendedDataContext.ofData((DataContext)MapDataContext.of((Map)result.toMap()));
    }

    public ExtendedDataContext update(LocalId id, DataContext dataContext) {
        ExtendedDataContext edc = (ExtendedDataContext)dataContext.as(ExtendedDataContext.class);
        TaskMetaDataContext mdc = (TaskMetaDataContext)edc.meta().as(TaskMetaDataContext.class);
        SecurityPolicy securityPolicy = this.convertPolicyObject(mdc.policy());
        TaskInstanceId taskInstanceId = (TaskInstanceId)ProcessIdParser.select((LocalId)id, TaskInstanceId.class);
        ProcessInstanceId instanceId = taskInstanceId.taskId().processInstanceId();
        Process<MappableToModel<Model>> process = this.parseProcess(instanceId.processId());
        String taskInstanceIdString = taskInstanceId.taskInstanceId();
        String processInstanceIdString = instanceId.processInstanceId();
        Map map = ((MapDataContext)dataContext.as(MapDataContext.class)).toMap();
        Map result = ((Model)((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(processInstanceIdString).map(pi -> {
            pi.updateWorkItem(taskInstanceIdString, wi -> HumanTaskHelper.updateContent((KogitoWorkItem)wi, (Map)map), new Policy[]{securityPolicy});
            return (Model)((MappableToModel)pi.variables()).toModel();
        }))).orElseThrow()).toMap();
        return ExtendedDataContext.ofData((DataContext)MapDataContext.of((Map)result));
    }

    private SecurityPolicy convertPolicyObject(org.kie.kogito.incubation.processes.services.contexts.Policy policy) {
        return SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)policy.user(), (Collection)policy.groups()));
    }
}

