/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.rules.hotreload;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class HotReloadIT {
    private static final String PACKAGE = "org.kie.kogito.quarkus.rules.hotreload";
    private static final String RESOURCE_FILE = "org.kie.kogito.quarkus.rules.hotreload".replace('.', '/') + "/adult.drl";
    private static final String HTTP_TEST_PORT = "65535";
    @RegisterExtension
    static final QuarkusDevModeTest test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource("adult.txt", RESOURCE_FILE));

    @Test
    public void testServletChange() throws InterruptedException {
        String personsPayload = "{\"persons\":[{\"name\":\"Mario\",\"age\":45,\"adult\":false},{\"name\":\"Sofia\",\"age\":17,\"adult\":false}]}";
        List names = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).body(personsPayload).when().post("/find-adult-names", new Object[0])).then()).statusCode(200)).extract().as(List.class);
        Assertions.assertEquals((int)1, (int)names.size());
        Assertions.assertEquals((Object)"Mario", names.get(0));
        test.modifyResourceFile(RESOURCE_FILE, s -> s.replaceAll("18", "16"));
        names = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).body(personsPayload).when().post("/find-adult-names", new Object[0])).then()).statusCode(200)).extract().as(List.class);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertTrue((boolean)names.contains("Mario"));
        Assertions.assertTrue((boolean)names.contains("Sofia"));
    }
}

