/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.rules.hotreload;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.kie.kogito.quarkus.rules.hotreload.newunit.Person;

public class ChangePojoIT {
    private static final String PACKAGE = "org.kie.kogito.quarkus.rules.hotreload";
    private static final String RESOURCE_FILE;
    @RegisterExtension
    static final QuarkusDevModeTest test;
    private static String POJO2;
    private static String DRL2;

    @Test
    public void test1Change() {
        this.doTest(true);
    }

    @Test
    public void test2Changes() {
        this.doTest(false);
    }

    private void doTest(boolean allChangesAtOnce) {
        String personsPayload1 = "{\"persons\":[{\"name\":\"Mario\",\"age\":45,\"adult\":false},{\"name\":\"Sofia\",\"age\":17,\"adult\":false}]}";
        String personsPayload2 = "{\"persons\":[{\"name\":\"Mario\",\"surname\":\"Fusco\",\"age\":45,\"adult\":false},{\"name\":\"Sofia\",\"surname\":\"Fusco\",\"age\":17,\"adult\":false}]}";
        String httpPort = (String)ConfigProvider.getConfig().getValue("quarkus.http.port", String.class);
        List persons = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + httpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body(personsPayload1).when().post("/find-adults", new Object[0])).then()).statusCode(200)).extract().as(List.class);
        Assertions.assertEquals((int)1, (int)persons.size());
        Assertions.assertEquals((Object)"Mario", ((Map)persons.get(0)).get("name"));
        test.modifySourceFile(Person.class, s -> POJO2);
        if (!allChangesAtOnce) {
            persons = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + httpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body(personsPayload2).when().post("/find-adults", new Object[0])).then()).statusCode(200)).extract().as(List.class);
            Assertions.assertEquals((int)1, (int)persons.size());
            Assertions.assertEquals((Object)"Mario", ((Map)persons.get(0)).get("name"));
        }
        test.modifyResourceFile(RESOURCE_FILE, s -> DRL2);
        persons = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + httpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body(personsPayload2).when().post("/find-adults", new Object[0])).then()).statusCode(200)).extract().as(List.class);
        Assertions.assertEquals((int)2, (int)persons.size());
        Assertions.assertTrue((boolean)persons.stream().map(p -> p.get("name")).allMatch(n -> n.equals("Mario") || n.equals("Sofia")));
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        RESOURCE_FILE = PACKAGE.replace('.', '/') + "/adult.drl";
        test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Person.class)).addAsResource("drl1.txt", RESOURCE_FILE));
        POJO2 = "package org.kie.kogito.quarkus.rules.hotreload.newunit;\n\npublic class Person {\n\n    private String name;\n    private String surname;\n\n    private int age;\n\n    private boolean adult;\n\n    public Person() {\n    }\n\n    public String getName() {\n        return name;\n    }\n\n    public void setName(String name) {\n        this.name = name;\n    }\n\n    public String getSurname() {\n        return surname;\n    }\n\n    public void setSurname( String surname ) {\n        this.surname = surname;\n    }\n\n    public int getAge() {\n        return age;\n    }\n\n    public void setAge(int age) {\n        this.age = age;\n    }\n\n    public boolean isAdult() {\n        return adult;\n    }\n\n    public void setAdult(boolean adult) {\n        this.adult = adult;\n    }\n\n}\n";
        DRL2 = "package io.quarkus.it.kogito.drools;\nunit AdultUnit;\n\nimport org.kie.kogito.quarkus.rules.hotreload.newunit.Person;\n\nimport org.drools.ruleunits.api.DataStore;\nimport org.drools.ruleunits.api.RuleUnitData;\n\ndeclare AdultUnit extends RuleUnitData\n   persons: DataStore<Person>\nend\n\nrule CheckAdult when\n    $p: /persons[ age >= 16, surname == \"Fusco\" ]\nthen\n    modify($p) { setAdult(true) };\nend\n\nrule CheckNotAdult when\n    $p: /persons[ age < 16, surname == \"Fusco\" ]\nthen\n    modify($p) { setAdult(false) };\nend\n\nquery FindAdultNames\n    /persons[ adult, $name : name ]\nend\nquery FindAdults\n    $p: /persons[ adult ]\nend\n";
    }
}

