/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.rules.hotreload.newunit;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.kie.kogito.quarkus.rules.hotreload.newunit.Person;
import org.kie.kogito.quarkus.rules.hotreload.newunit.PersonUnit;

public class NewUnitIT {
    private static final String PACKAGE = "org.kie.kogito.quarkus.rules.hotreload.newunit";
    private static final String RESOURCE_FILE_PATH = "org.kie.kogito.quarkus.rules.hotreload.newunit".replace('.', '/');
    private static final String DRL_RESOURCE_FILE = RESOURCE_FILE_PATH + "/rules.drl";
    private static final String DRL_SOURCE = "package org.kie.kogito.quarkus.rules.hotreload.newunit;\nunit PersonUnit;\n\nimport org.kie.kogito.quarkus.rules.hotreload.newunit.Person;\n\nrule \"adult\"\nwhen\n    $p: /persons[age >= 18];\nthen\n    modify($p) { setAdult(true) };\nend\n\nquery FindAdultNames\n    /persons[adult, $name: name];\nend";
    @RegisterExtension
    static final QuarkusDevModeTest test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Person.class)).addClass(PersonUnit.class)).addAsResource("adult.txt", DRL_RESOURCE_FILE + ".dummy"));

    @Test
    public void testServletChange() {
        String httpPort = (String)ConfigProvider.getConfig().getValue("quarkus.http.port", String.class);
        String personsPayload = "{\"persons\":[{\"name\":\"Mario\",\"age\":45,\"adult\":false},{\"name\":\"Sofia\",\"age\":17,\"adult\":false}]}";
        test.addResourceFile(DRL_RESOURCE_FILE, DRL_SOURCE);
        List names = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + httpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body(personsPayload).when().post("/find-adult-names", new Object[0])).then()).statusCode(200)).extract().as(List.class);
        Assertions.assertEquals((int)1, (int)names.size());
        Assertions.assertTrue((boolean)names.contains("Mario"));
    }
}

