/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.drools;

import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.EmptyDataContext;
import org.kie.kogito.incubation.common.ExtendedReferenceContext;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.ReferenceContext;
import org.kie.kogito.incubation.rules.services.adapters.RuleUnitInstance;
import org.kie.kogito.quarkus.drools.AnotherService;
import org.kie.kogito.quarkus.drools.StringHolder;

@QuarkusTest
public class StatefulRuleUnitAltAPITest {
    @Inject
    RuleUnitInstance<AnotherService> instance;

    @Test
    void testCreate() {
        Assertions.assertEquals((Object)"/rule-units/org.kie.kogito.quarkus.drools.AnotherService", (Object)this.instance.id().ruleUnitId().asLocalUri().path());
    }

    @Test
    void testQuery() {
        AnotherService ctx = (AnotherService)this.instance.context();
        ctx.getStrings().add((Object)new StringHolder("hello folks"));
        ctx.getStrings().add((Object)new StringHolder("hello people"));
        ctx.getStrings().add((Object)new StringHolder("hello Mario"));
        ctx.getStrings().add((Object)new StringHolder("helicopter"));
        Stream result = this.instance.query("Strings", ExtendedReferenceContext.ofData((ReferenceContext)EmptyDataContext.Instance));
        List strings = result.map(e -> ((StringHolder)((MapDataContext)e.data().as(MapDataContext.class)).get("results", StringHolder.class)).getValue()).collect(Collectors.toList());
        strings.removeAll(List.of("hello folks", "hello people", "hello Mario"));
        Assertions.assertTrue((boolean)strings.isEmpty());
    }
}

