/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.drools;

import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.application.AppRoot;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.EmptyDataContext;
import org.kie.kogito.incubation.common.ExtendedReferenceContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.ReferenceContext;
import org.kie.kogito.incubation.rules.InstanceQueryId;
import org.kie.kogito.incubation.rules.RuleUnitId;
import org.kie.kogito.incubation.rules.RuleUnitIds;
import org.kie.kogito.incubation.rules.RuleUnitInstanceId;
import org.kie.kogito.incubation.rules.data.DataSourceId;
import org.kie.kogito.incubation.rules.services.DataSourceService;
import org.kie.kogito.incubation.rules.services.StatefulRuleUnitService;
import org.kie.kogito.incubation.rules.services.contexts.RuleUnitMetaDataContext;
import org.kie.kogito.quarkus.drools.AnotherService;
import org.kie.kogito.quarkus.drools.StringHolder;
import org.kie.kogito.rules.DataSource;

@QuarkusTest
public class StatefulRuleUnitServiceTest {
    @Inject
    AppRoot appRoot;
    @Inject
    StatefulRuleUnitService ruleUnitService;
    @Inject
    DataSourceService dataSourceService;

    @Test
    void testCreate() {
        AnotherService ruleUnitData = new AnotherService(DataSource.createStore(), DataSource.createStore());
        RuleUnitId id = ((RuleUnitIds)this.appRoot.get(RuleUnitIds.class)).get(AnotherService.class);
        MetaDataContext result = this.ruleUnitService.create((LocalId)id, ExtendedReferenceContext.ofData((ReferenceContext)ruleUnitData));
        RuleUnitMetaDataContext meta = (RuleUnitMetaDataContext)result.as(RuleUnitMetaDataContext.class);
        RuleUnitInstanceId instanceId = (RuleUnitInstanceId)meta.id(RuleUnitInstanceId.class);
        Assertions.assertEquals((Object)"/rule-units/org.kie.kogito.quarkus.drools.AnotherService", (Object)instanceId.ruleUnitId().asLocalUri().path());
    }

    @Test
    void testQueryDsService() {
        AnotherService ruleUnitData = new AnotherService(DataSource.createStore(), DataSource.createStore());
        RuleUnitId id = ((RuleUnitIds)this.appRoot.get(RuleUnitIds.class)).get(AnotherService.class);
        MetaDataContext created = this.ruleUnitService.create((LocalId)id, ExtendedReferenceContext.ofData((ReferenceContext)ruleUnitData));
        RuleUnitMetaDataContext meta = (RuleUnitMetaDataContext)created.as(RuleUnitMetaDataContext.class);
        RuleUnitInstanceId ruid = (RuleUnitInstanceId)meta.id(RuleUnitInstanceId.class);
        InstanceQueryId queryId = ruid.queries().get("Strings");
        DataSourceId dataSourceId = ruid.dataSources().get("strings");
        this.dataSourceService.add((LocalId)dataSourceId, (DataContext)new StringHolder("hello folks"));
        this.dataSourceService.add((LocalId)dataSourceId, (DataContext)new StringHolder("hello people"));
        this.dataSourceService.add((LocalId)dataSourceId, (DataContext)new StringHolder("hello Mario"));
        this.dataSourceService.add((LocalId)dataSourceId, (DataContext)new StringHolder("helicopter"));
        Stream result = this.ruleUnitService.query((LocalId)queryId, ExtendedReferenceContext.ofData((ReferenceContext)EmptyDataContext.Instance));
        List strings = result.map(e -> ((StringHolder)((MapDataContext)e.data().as(MapDataContext.class)).get("results", StringHolder.class)).getValue()).collect(Collectors.toList());
        Assertions.assertFalse((boolean)strings.isEmpty());
        strings.removeAll(List.of("hello folks", "hello people", "hello Mario"));
        Assertions.assertTrue((boolean)strings.isEmpty());
    }

    @Test
    void testQueryDirectDs() {
        AnotherService ruleUnitData = new AnotherService(DataSource.createStore(), DataSource.createStore());
        RuleUnitId id = ((RuleUnitIds)this.appRoot.get(RuleUnitIds.class)).get(AnotherService.class);
        MetaDataContext created = this.ruleUnitService.create((LocalId)id, ExtendedReferenceContext.ofData((ReferenceContext)ruleUnitData));
        RuleUnitMetaDataContext meta = (RuleUnitMetaDataContext)created.as(RuleUnitMetaDataContext.class);
        RuleUnitInstanceId ruid = (RuleUnitInstanceId)meta.id(RuleUnitInstanceId.class);
        InstanceQueryId queryId = ruid.queries().get("Strings");
        ruleUnitData.getStrings().add((Object)new StringHolder("hello folks"));
        ruleUnitData.getStrings().add((Object)new StringHolder("hello people"));
        ruleUnitData.getStrings().add((Object)new StringHolder("hello Mario"));
        ruleUnitData.getStrings().add((Object)new StringHolder("helicopter"));
        Stream result = this.ruleUnitService.query((LocalId)queryId, ExtendedReferenceContext.ofData((ReferenceContext)EmptyDataContext.Instance));
        List strings = result.map(e -> ((StringHolder)((MapDataContext)e.data().as(MapDataContext.class)).get("results", StringHolder.class)).getValue()).collect(Collectors.toList());
        Assertions.assertFalse((boolean)strings.isEmpty());
        strings.removeAll(List.of("hello folks", "hello people", "hello Mario"));
        Assertions.assertTrue((boolean)strings.isEmpty());
    }
}

