/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.drools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.EmptyDataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.rules.RuleUnitId;
import org.kie.kogito.incubation.rules.RuleUnitIds;
import org.kie.kogito.incubation.rules.services.contexts.RuleUnitMetaDataContext;
import org.kie.kogito.quarkus.drools.AnotherService;

@QuarkusTest
public class RuleUnitMetaDataContextSerializationTest {
    @Inject
    ObjectMapper mapper;
    @Inject
    RuleUnitIds ruleUnitRoot;

    @Test
    void ensureRuleUnitMetaDataSerializable() throws JsonProcessingException {
        RuleUnitId id = this.ruleUnitRoot.get(AnotherService.class);
        String path = id.asLocalUri().path();
        RuleUnitMetaDataContext mdc = RuleUnitMetaDataContext.of((LocalId)id);
        String out = this.mapper.writeValueAsString((Object)mdc);
        Assertions.assertEquals((Object)"{\"id\":\"/rule-units/org.kie.kogito.quarkus.drools.AnotherService\"}", (Object)out);
        Map m = (Map)this.mapper.convertValue((Object)mdc, Map.class);
        Assertions.assertEquals(Map.of("id", path), (Object)m);
    }

    @Test
    void ensureExtendedMetaDataSerializable() throws JsonProcessingException {
        RuleUnitId id = this.ruleUnitRoot.get(AnotherService.class);
        RuleUnitMetaDataContext mdc = RuleUnitMetaDataContext.of((LocalId)id);
        ExtendedDataContext edc = ExtendedDataContext.of((MetaDataContext)mdc, (DataContext)EmptyDataContext.Instance);
        String out = this.mapper.writeValueAsString((Object)edc);
        Assertions.assertEquals((Object)"{\"meta\":{\"id\":\"/rule-units/org.kie.kogito.quarkus.drools.AnotherService\"},\"data\":{}}", (Object)out);
    }
}

