/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.rules.incubation.quarkus.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.DataStore;
import org.kie.kogito.rules.DataStream;
import org.kie.kogito.rules.SingletonStore;

class RuleUnitDataJacksonModule
extends SimpleModule {
    public RuleUnitDataJacksonModule() {
        this.addDefaultSerializers();
        this.addDefaultDeserializers();
    }

    private void addDefaultSerializers() {
    }

    private void addDefaultDeserializers() {
        this.addDeserializer(DataStream.class, new DataStreamDeserializer());
        this.addDeserializer(DataStore.class, new DataStoreDeserializer());
        this.addDeserializer(SingletonStore.class, new SingletonStoreDeserializer());
    }

    public static class SingletonStoreDeserializer
    extends JsonDeserializer<SingletonStore<?>>
    implements ContextualDeserializer {
        private JavaType javaType;

        public SingletonStore deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            SingletonStore store = DataSource.createSingleton();
            store.set(ctxt.readValue(jp, this.javaType));
            return store;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType javaType = property.getType().containedType(0);
            SingletonStoreDeserializer deserializer = new SingletonStoreDeserializer();
            deserializer.javaType = javaType;
            return deserializer;
        }
    }

    public static class DataStoreDeserializer
    extends JsonDeserializer<DataStore<?>>
    implements ContextualDeserializer {
        private CollectionType collectionType;

        public DataStore deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            DataStore store = DataSource.createStore();
            List list = (List)ctxt.readValue(jp, (JavaType)this.collectionType);
            list.forEach(arg_0 -> ((DataStore)store).add(arg_0));
            return store;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            CollectionType collectionType = ctxt.getTypeFactory().constructCollectionType(List.class, property.getType().containedType(0));
            DataStoreDeserializer deserializer = new DataStoreDeserializer();
            deserializer.collectionType = collectionType;
            return deserializer;
        }
    }

    public static class DataStreamDeserializer
    extends JsonDeserializer<DataStream<?>>
    implements ContextualDeserializer {
        private CollectionType collectionType;

        public DataStream deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            DataStream stream = DataSource.createStream();
            List list = (List)ctxt.readValue(jp, (JavaType)this.collectionType);
            list.forEach(arg_0 -> ((DataStream)stream).append(arg_0));
            return stream;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            CollectionType collectionType = ctxt.getTypeFactory().constructCollectionType(List.class, property.getType().containedType(0));
            DataStreamDeserializer deserializer = new DataStreamDeserializer();
            deserializer.collectionType = collectionType;
            return deserializer;
        }
    }
}

