/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.rules.incubation.quarkus.support;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnits;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.Id;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.objectmapper.InternalObjectMapper;
import org.kie.kogito.incubation.rules.QueryId;
import org.kie.kogito.incubation.rules.RuleUnitId;
import org.kie.kogito.incubation.rules.services.RuleUnitService;

class RuleUnitServiceImpl
implements RuleUnitService {
    private final RuleUnits ruleUnits;

    public RuleUnitServiceImpl(RuleUnits ruleUnits) {
        this.ruleUnits = ruleUnits;
    }

    public Stream<DataContext> evaluate(Id id, DataContext inputContext) {
        if (!(id instanceof QueryId)) {
            throw new IllegalArgumentException("Not a valid query id " + id.toLocalId());
        }
        QueryId queryId = (QueryId)id;
        RuleUnitId ruleUnitId = queryId.ruleUnitId();
        Map payload = ((MapDataContext)inputContext.as(MapDataContext.class)).toMap();
        RuleUnitData ruleUnitData = this.convertValue(payload, ruleUnitId);
        RuleUnit ruleUnit = this.ruleUnits.create(ruleUnitData.getClass());
        RuleUnitInstance instance = ruleUnit.createInstance(ruleUnitData);
        List results = instance.executeQuery(queryId.queryId(), new Object[0]).toList();
        return results.stream().map(MapDataContext::of);
    }

    private RuleUnitData convertValue(Map<String, Object> payload, RuleUnitId ruleUnitId) {
        try {
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(ruleUnitId.ruleUnitId());
            return (RuleUnitData)InternalObjectMapper.objectMapper().convertValue(payload, type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load class " + ruleUnitId.ruleUnitId(), e);
        }
    }
}

