/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.devservices;

import com.fasterxml.jackson.databind.JsonNode;
import org.kie.api.event.process.ProcessEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.quarkus.processes.devservices.DevModeWorkflowLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeServerlessWorkflowLogger
extends DevModeWorkflowLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevModeServerlessWorkflowLogger.class);

    public void beforeProcessStarted(ProcessStartedEvent event) {
        if (this.isSWEvent((ProcessEvent)event)) {
            LOGGER.info("Starting workflow '{}' ({})", (Object)event.getProcessInstance().getProcessId(), (Object)((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            JsonNode node = (JsonNode)((KogitoProcessInstance)event.getProcessInstance()).getVariables().get("workflowdata");
            if (!node.isEmpty()) {
                LOGGER.info("Workflow data \n{}", (Object)node.toPrettyString());
            }
        } else {
            super.beforeProcessStarted(event);
        }
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        if (this.isSWEvent((ProcessEvent)event)) {
            String nodeName = event.getNodeInstance().getNodeName();
            if (!("EmbeddedStart".equals(nodeName) || "EmbeddedEnd".equals(nodeName) || "Script".equals(nodeName))) {
                LOGGER.info("Triggered node '{}' for process '{}' ({})", new Object[]{nodeName, event.getProcessInstance().getProcessId(), ((KogitoProcessInstance)event.getProcessInstance()).getStringId()});
            }
        } else {
            super.beforeNodeTriggered(event);
        }
    }

    protected boolean isSWEvent(ProcessEvent event) {
        return LOGGER.isInfoEnabled() && event.getProcessInstance().getProcess().getType().equals("SW");
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        if (this.isSWEvent((ProcessEvent)event)) {
            if (event.getVariableId().startsWith("workflowdata") && event.getNewValue() instanceof JsonNode) {
                if (event.getVariableId().length() == "workflowdata".length()) {
                    if (event.getOldValue() != null) {
                        LOGGER.info("Workflow data change\n{}", (Object)((JsonNode)event.getNewValue()).toPrettyString());
                    }
                } else {
                    LOGGER.info("Property '{}' changed value from: '{}', to: '{}'", new Object[]{event.getVariableId(), event.getOldValue(), event.getNewValue()});
                }
            }
        } else {
            super.afterVariableChanged(event);
        }
    }
}

