/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.openapi;

import io.smallrye.openapi.api.util.MergeUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;

public final class ServerlessWorkflowOASFilter
implements OASFilter {
    private final Collection<SchemaInfo> inputModelSchemaInfos;

    public ServerlessWorkflowOASFilter(Collection<SchemaInfo> inputModelSchemaInfos) {
        this.inputModelSchemaInfos = inputModelSchemaInfos;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        for (SchemaInfo inputModelSchemaInfo : this.inputModelSchemaInfos) {
            if (inputModelSchemaInfo.openAPI == null) continue;
            MergeUtil.merge((OpenAPI)openAPI, (OpenAPI)inputModelSchemaInfo.openAPI);
            ServerlessWorkflowOASFilter.addWorkflowdataSchemaRefs(inputModelSchemaInfo, openAPI);
        }
        this.removeJsonModelInfoSchemaReferences(openAPI);
    }

    private void removeJsonModelInfoSchemaReferences(OpenAPI openAPI) {
        this.getPathItemsWithoutDefinedSchema(openAPI).forEach(pathItem -> this.getMediaTypesThatHaveJsonNodeModelInputSchema((PathItem)pathItem).forEach(this::setObjectSchema));
    }

    private void setObjectSchema(MediaType mediaType) {
        mediaType.setSchema(OASFactory.createSchema().type(Schema.SchemaType.OBJECT));
    }

    private Stream<MediaType> getMediaTypesThatHaveJsonNodeModelInputSchema(PathItem pathItem) {
        return ServerlessWorkflowOASFilter.getMediaTypes(pathItem).stream().filter(this::mediaTypeHasJsonNodeModelInputSchema);
    }

    private boolean mediaTypeHasJsonNodeModelInputSchema(MediaType mediaType) {
        return mediaType != null && "#/components/schemas/JsonNodeModelInput".equals(mediaType.getSchema().getRef());
    }

    private Stream<PathItem> getPathItemsWithoutDefinedSchema(OpenAPI openAPI) {
        return openAPI.getPaths().getPathItems().values().stream().filter(Predicate.not(this::doesExistSchemaForPathItem));
    }

    private boolean doesExistSchemaForPathItem(PathItem pathItem) {
        return this.inputModelSchemaInfos.stream().anyMatch(schemaInfo -> ServerlessWorkflowOASFilter.pathItemHasWorkflowId(pathItem, schemaInfo.workflowId));
    }

    private static boolean pathItemHasWorkflowId(PathItem pathItem, String workflowId) {
        return pathItem.getPOST() != null && pathItem.getPOST().getOperationId() != null && pathItem.getPOST().getOperationId().matches("createResource_" + workflowId);
    }

    private static void addWorkflowdataSchemaRefs(SchemaInfo schemaInfo, OpenAPI openAPI) {
        Schema schema = (Schema)OASFactory.createSchema().ref(schemaInfo.inputModelRef);
        for (PathItem pathItem : openAPI.getPaths().getPathItems().values()) {
            if (!ServerlessWorkflowOASFilter.pathItemHasWorkflowId(pathItem, schemaInfo.workflowId)) continue;
            ServerlessWorkflowOASFilter.getMediaTypes(pathItem).forEach(mediaType -> mediaType.setSchema(schema));
        }
    }

    private static Collection<MediaType> getMediaTypes(PathItem pathItem) {
        if (ServerlessWorkflowOASFilter.pathItemHasPostMethodWithMediaTypes(pathItem)) {
            return pathItem.getPOST().getRequestBody().getContent().getMediaTypes().values();
        }
        return List.of();
    }

    private static boolean pathItemHasPostMethodWithMediaTypes(PathItem pathItem) {
        return pathItem.getPOST() != null && pathItem.getPOST().getRequestBody() != null && pathItem.getPOST().getRequestBody().getContent() != null && pathItem.getPOST().getRequestBody().getContent().getMediaTypes() != null;
    }

    public static final class SchemaInfo {
        private final String workflowId;
        private final OpenAPI openAPI;
        private final String inputModelRef;

        public SchemaInfo(String workflowId, OpenAPI openAPI, String inputModelRef) {
            this.workflowId = workflowId;
            this.openAPI = openAPI;
            this.inputModelRef = inputModelRef;
        }
    }
}

