/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;
import org.mockito.Mockito;

class MongoDBQuarkusTestResourceTest {
    private MongoDBQuarkusTestResource resource;

    MongoDBQuarkusTestResourceTest() {
    }

    @Test
    void shouldGetProperty() {
        this.givenResource();
        Assertions.assertThrows(IllegalStateException.class, () -> this.resource.getProperties().get("quarkus.mongodb.connection-string"));
    }

    @Test
    void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    @Test
    void shouldGetDockerImageName() {
        this.givenResource();
        Assertions.assertEquals((Object)("library/" + System.getProperty("container.image.mongodb")), (Object)((KogitoMongoDBContainer)this.resource.getTestResource()).getDockerImageName());
    }

    private void givenConditionalResource() {
        this.resource = (MongoDBQuarkusTestResource)Mockito.spy((Object)new MongoDBQuarkusTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (MongoDBQuarkusTestResource)Mockito.spy((Object)new MongoDBQuarkusTestResource());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

