/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.resources;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.test.resources.ConditionHolder;
import org.kie.kogito.test.resources.ConditionalQuarkusTestResource;
import org.kie.kogito.test.resources.TestResource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ConditionalQuarkusTestResourceTest {
    private static final int MAPPED_PORT = 8800;
    private static final String KOGITO_PROPERTY = "my-kogito-property";
    private static final String KOGITO_PROPERTY_VALUE = "localhost:8800";
    @Mock
    private TestResource resource;
    @Mock
    private ConditionHolder conditional;
    private ConditionalQuarkusTestResource instance;
    private Map<String, String> actualOutput;
    private TestInstance testInstance;

    @BeforeEach
    public void setup() {
        this.instance = new ConditionalQuarkusTestResource(this.resource, this.conditional){

            protected Map<String, String> getProperties() {
                return Collections.singletonMap(ConditionalQuarkusTestResourceTest.KOGITO_PROPERTY, ConditionalQuarkusTestResourceTest.KOGITO_PROPERTY_VALUE);
            }
        };
        this.actualOutput = null;
        this.testInstance = new TestInstance();
        Mockito.lenient().when((Object)this.resource.getMappedPort()).thenReturn((Object)8800);
    }

    @Test
    public void shouldReturnResource() {
        Assertions.assertEquals((Object)this.resource, (Object)this.instance.getTestResource());
    }

    @Test
    public void shouldInvokeConditional() {
        this.instance.enableConditional();
        ((ConditionHolder)Mockito.verify((Object)this.conditional)).enableConditional();
    }

    @Test
    public void shouldStartIfConditionalIsEnabled() {
        this.givenConditionalEnabled();
        this.whenStartInstance();
        this.thenResourceIsStarted();
        this.thenConfigMapIsUpdated();
    }

    @Test
    public void shouldNotStartIfConditionalIsDisabled() {
        this.givenConditionalDisabled();
        this.whenStartInstance();
        this.thenResourceIsNotUsed();
    }

    @Test
    public void shouldStopIfConditionalIsEnabled() {
        this.givenConditionalEnabled();
        this.whenStopInstance();
        this.thenResourceIsStopped();
    }

    @Test
    public void shouldNotStopIfConditionalIsDisabled() {
        this.givenConditionalDisabled();
        this.whenStopInstance();
        this.thenResourceIsNotUsed();
    }

    @Test
    public void shouldInjectConfigProperty() {
        this.whenInjectTestInstance();
        this.thenKogitoPropertyIsUpdated();
        this.thenAnotherPropertyIsNotUpdated();
        this.thenResourceIsUpdated();
    }

    private void givenConditionalEnabled() {
        Mockito.when((Object)this.conditional.isEnabled()).thenReturn((Object)true);
    }

    private void givenConditionalDisabled() {
        Mockito.when((Object)this.conditional.isEnabled()).thenReturn((Object)false);
    }

    private void whenStartInstance() {
        this.actualOutput = this.instance.start();
    }

    private void whenStopInstance() {
        this.instance.stop();
    }

    private void whenInjectTestInstance() {
        this.instance.inject((Object)this.testInstance);
    }

    private void thenResourceIsStarted() {
        ((TestResource)Mockito.verify((Object)this.resource)).start();
    }

    private void thenResourceIsStopped() {
        ((TestResource)Mockito.verify((Object)this.resource)).stop();
    }

    private void thenResourceIsNotUsed() {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.resource});
    }

    private void thenConfigMapIsUpdated() {
        String actual = this.actualOutput.get(KOGITO_PROPERTY);
        Assertions.assertEquals((Object)KOGITO_PROPERTY_VALUE, (Object)actual);
    }

    private void thenKogitoPropertyIsUpdated() {
        Assertions.assertEquals((Object)KOGITO_PROPERTY_VALUE, (Object)this.testInstance.kogitoProperty);
    }

    private void thenAnotherPropertyIsNotUpdated() {
        Assertions.assertNull((Object)this.testInstance.anotherProperty);
    }

    private void thenResourceIsUpdated() {
        Assertions.assertEquals((Object)this.instance, (Object)this.testInstance.resource);
    }

    private class TestInstance {
        @ConfigProperty(name="my-kogito-property")
        private String kogitoProperty;
        @ConfigProperty(name="another-property")
        private String anotherProperty;
        @Resource
        private ConditionalQuarkusTestResource resource;

        private TestInstance() {
        }
    }
}

