/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.kie.kogito.test.resources.ConditionalQuarkusTestResource;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaQuarkusTestResource
extends ConditionalQuarkusTestResource<KogitoKafkaContainer> {
    public static final String KOGITO_KAFKA_PROPERTY = "kafka.bootstrap.servers";
    public static final String KOGITO_KAFKA_TOPICS = "kogito.test.topics";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaQuarkusTestResource.class);
    private List<String> topics = Collections.emptyList();

    public KafkaQuarkusTestResource() {
        super(new KogitoKafkaContainer());
    }

    @Override
    protected Map<String, String> getProperties() {
        return Collections.singletonMap(KOGITO_KAFKA_PROPERTY, "localhost:" + ((KogitoKafkaContainer)this.getTestResource()).getMappedPort());
    }

    public void init(Map<String, String> initArgs) {
        String topicsString = initArgs.get(KOGITO_KAFKA_TOPICS);
        if (topicsString != null && !topicsString.trim().isEmpty()) {
            this.topics = Arrays.stream(topicsString.split(",")).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> start() {
        Map<String, String> props = super.start();
        String bootstrap = props.get(KOGITO_KAFKA_PROPERTY);
        if (bootstrap != null && !this.topics.isEmpty()) {
            AdminClient client = null;
            try {
                LOGGER.info("Create Kafka topics: {}", this.topics);
                client = AdminClient.create(Collections.singletonMap("bootstrap.servers", bootstrap));
                List newTopics = this.topics.stream().map(e -> new NewTopic(e, 1, 1)).collect(Collectors.toList());
                CreateTopicsResult result = client.createTopics(newTopics);
                result.all().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e2) {
                LOGGER.error("Error creating Kafka topics: {}", this.topics, (Object)e2);
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to close KafkaAdminClient {}", (Object)ex.getMessage(), (Object)ex);
                    }
                }
            }
        }
        return props;
    }

    public static class Conditional
    extends KafkaQuarkusTestResource {
        public Conditional() {
            this.enableConditional();
        }
    }
}

