/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.test.quarkus.kafka;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerLoop<T>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConsumerLoop.class);
    private final KafkaConsumer<String, T> consumer;
    private final Collection<String> topics;
    private final Consumer<T> callback;
    private final UnaryOperator<Void> onSubscribe;
    private final CountDownLatch shutdownLatch;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public KafkaConsumerLoop(KafkaConsumer<String, T> consumer, Collection<String> topics, Consumer<T> callback, UnaryOperator<Void> onSubscribe) {
        this.consumer = consumer;
        this.topics = topics;
        this.callback = callback;
        this.onSubscribe = onSubscribe;
        this.shutdownLatch = new CountDownLatch(1);
    }

    private boolean doCommitSync() {
        try {
            this.consumer.commitSync();
            return true;
        }
        catch (CommitFailedException e) {
            LOGGER.debug("Kafka commit failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public void run() {
        try {
            this.consumer.subscribe(this.topics, new ConsumerRebalanceListener(){

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    LOGGER.debug("Kafka consumer partitions revoked: {}", partitions);
                    KafkaConsumerLoop.this.doCommitSync();
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    LOGGER.debug("Kafka consumer partitions assigned: {}", partitions);
                }
            });
            LOGGER.debug("Kafka consumer subscribed to topic(s): {}", this.topics);
            this.onSubscribe.apply(null);
            while (this.running.get()) {
                ConsumerRecords records = this.consumer.poll(Duration.ofSeconds(1L));
                LOGGER.debug("Kafka consumer received records: {}", (Object)records);
                if (this.doCommitSync()) {
                    records.forEach(record -> this.callback.accept(record.value()));
                    continue;
                }
                LOGGER.warn("Kafka records ignored: {}", (Object)records);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
        finally {
            try {
                this.consumer.close();
                this.shutdownLatch.countDown();
                LOGGER.debug("Kafka consumer closed");
            }
            catch (Exception ex) {
                LOGGER.error("Error while closing Kafka consumer", (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        this.running.set(false);
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

