/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.quarkus;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.mockito.Mockito;

public class KafkaQuarkusTestResourceTest {
    private KafkaQuarkusTestResource resource;
    private static final String IMAGE = "vectorized/redpanda:latest";

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.kafka", IMAGE);
    }

    @Test
    public void shouldGetProperty() {
        this.givenResource();
        Assertions.assertThrows(IllegalStateException.class, () -> this.resource.getProperties().get("kafka.bootstrap.servers"));
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenConditionalResource() {
        this.resource = (KafkaQuarkusTestResource)Mockito.spy((Object)new KafkaQuarkusTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (KafkaQuarkusTestResource)Mockito.spy((Object)new KafkaQuarkusTestResource());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

