/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.tests.KogitoInfinispanSpringbootApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoInfinispanSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class ScriptsProcessTest {
    @Autowired
    @Qualifier(value="scripts")
    Process<? extends Model> scriptsProcess;

    @Test
    public void testOrderProcess() {
        Assert.assertNotNull(this.scriptsProcess);
        Model m = (Model)this.scriptsProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = this.scriptsProcess.createInstance(m);
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assert.assertEquals((long)2L, (long)result.toMap().size());
        Assert.assertEquals(result.toMap().get("message"), (Object)"Hello john");
    }
}

