/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.workflow.Functions;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;
import org.mockito.Mockito;

class BuildExpressionsTest {
    BuildExpressionsTest() {
    }

    @Test
    void testReplaceExpr() {
        Workflow flow = (Workflow)Mockito.mock(Workflow.class);
        FunctionDefinition functionDefinition = new FunctionDefinition();
        functionDefinition.setType(FunctionDefinition.Type.EXPRESSION);
        functionDefinition.setOperation(".pepe");
        functionDefinition.setName("pepe");
        Functions functions = new Functions(Collections.singletonList(functionDefinition));
        Mockito.when((Object)flow.getFunctions()).thenReturn((Object)functions);
        Assertions.assertThat((String)ExpressionHandlerUtils.replaceExpr((Workflow)flow, (String)"\"fn:pepe\"")).isEqualTo("\"fn:pepe\"");
        Assertions.assertThat((String)ExpressionHandlerUtils.replaceExpr((Workflow)flow, (String)"fn:pepe")).isEqualTo(".pepe");
        Assertions.assertThat((String)ExpressionHandlerUtils.replaceExpr((Workflow)flow, (String)"${fn:pepe}")).isEqualTo(".pepe");
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ExpressionHandlerUtils.replaceExpr((Workflow)flow, (String)"${fn:NoPepe}"));
    }
}

