/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import org.assertj.core.api.Assertions;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.api.definition.process.Node;
import org.kie.kogito.serverless.workflow.AbstractServerlessWorkflowParsingTest;
import org.kie.kogito.serverless.workflow.WorkflowTestUtils;

class CallbackStateServerlessWorkflowParsingTest
extends AbstractServerlessWorkflowParsingTest {
    CallbackStateServerlessWorkflowParsingTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/callback-state.sw.json", "/exec/callback-state.sw.yml"})
    void produceCallbackState(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        WorkflowTestUtils.assertProcessMainParams(process, "callback_state", "Callback State", "1.0", "org.kie.kogito.serverless", "Public");
        this.assertCallbackProcessMainStructure(process);
        CompositeContextNode callbackState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, CompositeContextNode.class);
        WorkflowTestUtils.assertHasNodesSize(callbackState, 6);
        StartNode stateStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 0, StartNode.class);
        WorkflowTestUtils.assertHasName((Node)stateStartNode, "EmbeddedStart");
        WorkItemNode stateActionNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 1, WorkItemNode.class);
        WorkflowTestUtils.assertHasName((Node)stateActionNode, "callbackFunction");
        ActionNode afterStateActionMergeNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 2, ActionNode.class);
        EventNode stateEventNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 3, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)stateEventNode, "callbackEvent");
        ActionNode afterStateEventMergeNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 4, ActionNode.class);
        EndNode stateEndNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 5, EndNode.class);
        WorkflowTestUtils.assertHasName((Node)stateEndNode, "EmbeddedEnd");
        WorkflowTestUtils.assertIsConnected((Node)stateStartNode, (Node)stateActionNode);
        WorkflowTestUtils.assertIsConnected((Node)stateActionNode, (Node)afterStateActionMergeNode);
        WorkflowTestUtils.assertIsConnected((Node)afterStateActionMergeNode, (Node)stateEventNode);
        WorkflowTestUtils.assertIsConnected((Node)stateEventNode, (Node)afterStateEventMergeNode);
        WorkflowTestUtils.assertIsConnected((Node)afterStateEventMergeNode, (Node)stateEndNode);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/callback-state-timeouts.sw.json", "/exec/callback-state-timeouts.sw.yml"})
    void produceCallbackStateWithTimeouts(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        WorkflowTestUtils.assertProcessMainParams(process, "callback_state_timeouts", "Callback State Timeouts", "1.0", "org.kie.kogito.serverless", "Public");
        this.assertCallbackProcessMainStructure(process);
        CompositeContextNode callbackState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, CompositeContextNode.class);
        WorkflowTestUtils.assertHasNodesSize(callbackState, 9);
        StartNode stateStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 0, StartNode.class);
        WorkflowTestUtils.assertHasName((Node)stateStartNode, "EmbeddedStart");
        WorkItemNode stateActionNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 1, WorkItemNode.class);
        WorkflowTestUtils.assertHasName((Node)stateActionNode, "callbackFunction");
        ActionNode afterStateActionMergeNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 2, ActionNode.class);
        Split stateSplitNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 3, Split.class);
        WorkflowTestUtils.assertHasName((Node)stateSplitNode, "ExclusiveSplit_" + stateSplitNode.getId());
        Join stateJoinNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 4, Join.class);
        WorkflowTestUtils.assertHasName((Node)stateJoinNode, "ExclusiveJoin_" + stateJoinNode.getId());
        EventNode stateEventNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 5, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)stateEventNode, "callbackEvent");
        ActionNode afterStateEventMergeNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 6, ActionNode.class);
        TimerNode stateTimerNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 7, TimerNode.class);
        WorkflowTestUtils.assertHasName((Node)stateTimerNode, "TimerNode_" + stateTimerNode.getId());
        Assertions.assertThat((String)stateTimerNode.getTimer().getDelay()).isEqualTo("PT5S");
        Assertions.assertThat((int)stateTimerNode.getTimer().getTimeType()).isEqualTo(1);
        EndNode stateEndNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)callbackState, 8, EndNode.class);
        WorkflowTestUtils.assertHasName((Node)stateEndNode, "EmbeddedEnd");
        WorkflowTestUtils.assertIsConnected((Node)stateStartNode, (Node)stateActionNode);
        WorkflowTestUtils.assertIsConnected((Node)stateActionNode, (Node)afterStateActionMergeNode);
        WorkflowTestUtils.assertIsConnected((Node)afterStateActionMergeNode, (Node)stateSplitNode);
        WorkflowTestUtils.assertIsConnected((Node)stateSplitNode, (Node)stateEventNode);
        WorkflowTestUtils.assertIsConnected((Node)stateEventNode, (Node)afterStateEventMergeNode);
        WorkflowTestUtils.assertIsConnected((Node)afterStateEventMergeNode, (Node)stateJoinNode);
        WorkflowTestUtils.assertIsConnected((Node)stateSplitNode, (Node)stateTimerNode);
        WorkflowTestUtils.assertIsConnected((Node)stateTimerNode, (Node)stateJoinNode);
        WorkflowTestUtils.assertIsConnected((Node)stateJoinNode, (Node)stateEndNode);
    }

    private void assertCallbackProcessMainStructure(RuleFlowProcess process) {
        WorkflowTestUtils.assertHasNodesSize(process, 7);
        StartNode processStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 0, StartNode.class);
        EndNode processEndNode1 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 1, EndNode.class);
        EndNode processEndNode2 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 2, EndNode.class);
        CompositeContextNode callbackState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)callbackState, "CallbackState");
        ActionNode processFinalizeSuccessfulState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 5, ActionNode.class);
        WorkflowTestUtils.assertHasName((Node)processFinalizeSuccessfulState, "FinalizeSuccessful");
        ActionNode processFinalizeWithErrorState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 6, ActionNode.class);
        WorkflowTestUtils.assertHasName((Node)processFinalizeWithErrorState, "FinalizeWithError");
        BoundaryEventNode callbackStateErrorBoundaryEvent = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 4, BoundaryEventNode.class);
        WorkflowTestUtils.assertHasName((Node)callbackStateErrorBoundaryEvent, "Error-CallbackState-java.lang.Exception");
        WorkflowTestUtils.assertIsConnected((Node)processStartNode, (Node)callbackState);
        WorkflowTestUtils.assertIsConnected((Node)callbackState, (Node)processFinalizeSuccessfulState);
        WorkflowTestUtils.assertIsConnected((Node)processFinalizeSuccessfulState, (Node)processEndNode1);
        WorkflowTestUtils.assertIsConnected((Node)processFinalizeWithErrorState, (Node)processEndNode2);
    }
}

