/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.states.SleepState;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.serverless.workflow.AbstractServerlessWorkflowParsingTest;
import org.kie.kogito.serverless.workflow.WorkflowTestUtils;
import org.kie.kogito.serverless.workflow.parser.ServerlessWorkflowParser;

public class ServerlessWorkflowParsingTest
extends AbstractServerlessWorkflowParsingTest {
    @ParameterizedTest
    @ValueSource(strings={"/exec/single-operation.sw.json", "/exec/single-operation.sw.yml"})
    public void testSingleOperationWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(3);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-operation-with-delay.sw.json", "/exec/single-operation-with-delay.sw.yml"})
    public void testSingleOperationWithDelayWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(4);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(TimerNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        TimerNode timerNode = (TimerNode)process.getNodes()[3];
        Assertions.assertThat((String)timerNode.getTimer().getDelay()).isEqualTo("PT1S");
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-service-operation.sw.json", "/exec/single-service-operation.sw.yml"})
    public void testSingleServiceOperationWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(3);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(WorkItemNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        WorkItemNode workItemNode = (WorkItemNode)compositeNode.getNodes()[1];
        Assertions.assertThat((String)workItemNode.getName()).isEqualTo("helloWorld");
        Assertions.assertThat((Object)workItemNode.getWork().getParameter("Interface")).isEqualTo((Object)"org.something.other.TestService");
        Assertions.assertThat((Object)workItemNode.getWork().getParameter("Operation")).isEqualTo((Object)"get");
        Assertions.assertThat((Object)workItemNode.getWork().getParameter("interfaceImplementationRef")).isEqualTo((Object)"org.something.other.TestService");
        Assertions.assertThat((Object)workItemNode.getWork().getParameter("operationImplementationRef")).isEqualTo((Object)"get");
        Assertions.assertThat((Object)workItemNode.getWork().getParameter("implementation")).isEqualTo((Object)"Java");
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-eventstate.sw.json", "/exec/single-eventstate.sw.yml"})
    public void testSingleEventStateWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(4);
        Node node = process.getNodes()[1];
        Assertions.assertThat((Object)((StartNode)node).getMetaData("TriggerRef")).isEqualTo((Object)"kafka");
        node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[3];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-eventstate-multi-eventrefs.sw.json", "/exec/single-eventstate-multi-eventrefs.sw.yml"})
    public void testSingleEventStateMultiEventRefsWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(7);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        node = process.getNodes()[6];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[5];
        Assertions.assertThat((Object)node).isInstanceOf(Join.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[6];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-operation-many-functions.sw.json", "/exec/single-operation-many-functions.sw.yml"})
    public void testSingleOperationWithManyFunctionsWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(3);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(6);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[4];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[5];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/multiple-operations.sw.json", "/exec/multiple-operations.sw.yml"})
    public void testMultipleOperationWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(5);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[4];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        compositeNode = (CompositeContextNode)process.getNodes()[3];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        compositeNode = (CompositeContextNode)process.getNodes()[4];
        Assertions.assertThat((Object[])compositeNode.getNodes()).hasSize(4);
        node = compositeNode.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = compositeNode.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(Node.class);
        node = compositeNode.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = compositeNode.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-inject-state.sw.json", "/exec/single-inject-state.sw.yml"})
    public void testSingleInjectWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("function");
        Assertions.assertThat((String)process.getName()).isEqualTo("test-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(3);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        ActionNode actionNode = (ActionNode)process.getNodes()[2];
        Assertions.assertThat((String)actionNode.getName()).isEqualTo("SimpleInject");
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/parallel-state.sw.json", "/exec/parallel-state.sw.yml"})
    public void testParallelWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("parallelworkflow");
        Assertions.assertThat((String)process.getName()).isEqualTo("parallel-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(6);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(Split.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(Join.class);
        node = process.getNodes()[4];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[5];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/transition-produce-event.sw.json", "/exec/transition-produce-event.sw.yml"})
    public void testProduceEventOnTransition(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("produceeventontransition");
        Assertions.assertThat((String)process.getName()).isEqualTo("Produce Event On Transition");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(5);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[4];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        ActionNode actionNode = (ActionNode)process.getNodes()[4];
        Assertions.assertThat((String)actionNode.getName()).isEqualTo("TestKafkaEvent");
        Assertions.assertThat((Object)actionNode.getMetaData("TriggerType")).isEqualTo((Object)"ProduceMessage");
        Assertions.assertThat((Object)actionNode.getMetaData("MappingVariable")).isEqualTo((Object)"workflowdata");
        Assertions.assertThat((Object)actionNode.getMetaData("TriggerRef")).isEqualTo((Object)"kafka");
        Assertions.assertThat((Object)actionNode.getMetaData("MessageType")).isEqualTo((Object)"com.fasterxml.jackson.databind.JsonNode");
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/eventbased-switch-state.sw.json", "/exec/eventbased-switch-state.sw.yml"})
    public void testEventBasedSwitchWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("eventswitchworkflow");
        Assertions.assertThat((String)process.getName()).isEqualTo("event-switch-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(12);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[4];
        Assertions.assertThat((Object)node).isInstanceOf(Split.class);
        node = process.getNodes()[5];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[6];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[7];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[8];
        Assertions.assertThat((Object)node).isInstanceOf(EventNode.class);
        node = process.getNodes()[10];
        Assertions.assertThat((Object)node).isInstanceOf(EventNode.class);
        Split split = (Split)process.getNodes()[4];
        Assertions.assertThat((String)split.getName()).isEqualTo("ChooseOnEvent");
        Assertions.assertThat((int)split.getType()).isEqualTo(4);
        EventNode firstEventNode = (EventNode)process.getNodes()[8];
        Assertions.assertThat((String)firstEventNode.getName()).isEqualTo("visaApprovedEvent");
        EventNode secondEventNode = (EventNode)process.getNodes()[10];
        Assertions.assertThat((String)secondEventNode.getName()).isEqualTo("visaDeniedEvent");
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/prchecker.sw.json", "/exec/prchecker.sw.yml"})
    public void testPrCheckerWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("prchecker");
        Assertions.assertThat((String)process.getName()).isEqualTo("Github PR Checker Workflow");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(11);
        Node node = process.getNodes()[5];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[4];
        Assertions.assertThat((Object)node).isInstanceOf(Join.class);
        node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[6];
        Assertions.assertThat((Object)node).isInstanceOf(Split.class);
        node = process.getNodes()[7];
        Assertions.assertThat((Object)node).isInstanceOf(Split.class);
        node = process.getNodes()[8];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[9];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        node = process.getNodes()[10];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        Split split = (Split)process.getNodes()[6];
        Assertions.assertThat((String)split.getName()).isEqualTo("CheckBackend");
        Assertions.assertThat((int)split.getType()).isEqualTo(2);
        Assertions.assertThat((Map)split.getConstraints()).hasSize(2);
        Split split2 = (Split)process.getNodes()[7];
        Assertions.assertThat((String)split2.getName()).isEqualTo("CheckFrontend");
        Assertions.assertThat((int)split2.getType()).isEqualTo(2);
        Assertions.assertThat((Map)split2.getConstraints()).hasSize(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/transition-produce-multi-events.sw.json", "/exec/transition-produce-multi-events.sw.yml"})
    public void testProduceMultiEventsOnTransition(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("produceeventontransition");
        Assertions.assertThat((String)process.getName()).isEqualTo("Produce Event On Transition");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(8);
        Node node = process.getNodes()[0];
        Assertions.assertThat((Object)node).isInstanceOf(StartNode.class);
        node = process.getNodes()[1];
        Assertions.assertThat((Object)node).isInstanceOf(EndNode.class);
        node = process.getNodes()[2];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[3];
        Assertions.assertThat((Object)node).isInstanceOf(CompositeContextNode.class);
        node = process.getNodes()[4];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[5];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[6];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        node = process.getNodes()[7];
        Assertions.assertThat((Object)node).isInstanceOf(ActionNode.class);
        ActionNode actionNode = (ActionNode)process.getNodes()[4];
        Assertions.assertThat((String)actionNode.getName()).isEqualTo("TestKafkaEvent");
        ActionNode actionNode2 = (ActionNode)process.getNodes()[5];
        Assertions.assertThat((String)actionNode2.getName()).isEqualTo("TestKafkaEvent2");
        ActionNode actionNode3 = (ActionNode)process.getNodes()[6];
        Assertions.assertThat((String)actionNode3.getName()).isEqualTo("TestKafkaEvent3");
        ActionNode actionNode4 = (ActionNode)process.getNodes()[7];
        Assertions.assertThat((String)actionNode4.getName()).isEqualTo("TestKafkaEvent4");
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state-produce-events.sw.json", "/exec/switch-state-produce-events.sw.yml"})
    public void testSwitchProduceEventsOnTransitionWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("switchworkflow");
        Assertions.assertThat((String)process.getName()).isEqualTo("switch-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(16);
        Split split = (Split)process.getNodes()[4];
        Assertions.assertThat((String)split.getName()).isEqualTo("ChooseOnAge");
        Assertions.assertThat((int)split.getType()).isEqualTo(2);
        Assertions.assertThat((Map)split.getConstraints()).hasSize(2);
        boolean haveDefaultConstraint = false;
        for (Constraint constraint : split.getConstraints().values()) {
            haveDefaultConstraint = haveDefaultConstraint || constraint.isDefault();
        }
        Assertions.assertThat((boolean)haveDefaultConstraint).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state-produce-events-default.sw.json"})
    public void testSwitchProduceEventsDefaultOnTransitionWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((String)process.getId()).isEqualTo("switchworkflow");
        Assertions.assertThat((String)process.getName()).isEqualTo("switch-wf");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getType()).isEqualTo("SW");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Object[])process.getNodes()).hasSize(17);
        Split split = (Split)process.getNodes()[4];
        Assertions.assertThat((String)split.getName()).isEqualTo("ChooseOnAge");
        Assertions.assertThat((int)split.getType()).isEqualTo(2);
        Assertions.assertThat((Map)split.getConstraints()).hasSize(2);
        boolean haveDefaultConstraint = false;
        for (Constraint constraint : split.getConstraints().values()) {
            haveDefaultConstraint = haveDefaultConstraint || constraint.isDefault();
        }
        Assertions.assertThat((boolean)haveDefaultConstraint).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"/examples/applicantworkflow.sw.json", "/exec/error.sw.json", "/exec/callback.sw.json", "/exec/compensation.sw.json", "/exec/compensation.end.sw.json", "/exec/foreach.sw.json"})
    public void testSpecExamplesParsing(String workflowLocation) throws IOException {
        Workflow workflow = Workflow.fromSource((String)WorkflowTestUtils.readWorkflowFile(workflowLocation));
        Assertions.assertThat((Object)workflow).isNotNull();
        Assertions.assertThat((String)workflow.getId()).isNotNull();
        Assertions.assertThat((String)workflow.getName()).isNotNull();
        ((ListAssert)Assertions.assertThat((List)workflow.getStates()).isNotNull()).hasSizeGreaterThan(0);
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((String)process.getId()).isNotNull();
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/expression.schema.sw.json"})
    public void testSpecWithInputSchema(String workflowLocation) throws IOException {
        Workflow workflow = Workflow.fromSource((String)WorkflowTestUtils.readWorkflowFile(workflowLocation));
        Assertions.assertThat((Object)workflow).isNotNull();
        Assertions.assertThat((Object)workflow.getDataInputSchema()).isNotNull();
        Assertions.assertThat((List)workflow.getStates()).hasSizeGreaterThan(0);
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((String)process.getId()).isNotNull();
        Assertions.assertThat((Object)process.getMetaData("dataInputScheme")).isEqualTo((Object)"#/components/schemas/workflowdata");
    }

    @Test
    public void testMinimumWorkflow() {
        Workflow workflow = ServerlessWorkflowParsingTest.createMinimumWorkflow();
        ServerlessWorkflowParser parser = ServerlessWorkflowParser.of((Workflow)workflow, (KogitoBuildContext)JavaKogitoBuildContext.builder().build());
        Process process = (Process)parser.getProcessInfo().info();
        Assertions.assertThat((Object)((KogitoWorkflowProcess)parser.getProcessInfo().info())).isSameAs((Object)process);
        Assertions.assertThat((String)process.getName()).isEqualTo("workflow");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
    }

    private static Workflow createMinimumWorkflow() {
        Workflow workflow = new Workflow();
        workflow.setId("javierito");
        Start start = new Start();
        start.setStateName("javierito");
        End end = new End();
        end.setTerminate(true);
        SleepState startState = new SleepState();
        startState.setType(DefaultState.Type.SLEEP);
        startState.setDuration("1s");
        startState.setName("javierito");
        startState.setEnd(end);
        workflow.setStates(List.of(startState));
        workflow.setStart(start);
        return workflow;
    }

    @Test
    void testWorkflowWithAnnotations() {
        List<String> annotations = List.of("machine learning", "monitoring", "networking");
        Workflow workflow = ServerlessWorkflowParsingTest.createMinimumWorkflow().withAnnotations(annotations);
        ServerlessWorkflowParser parser = ServerlessWorkflowParser.of((Workflow)workflow, (KogitoBuildContext)JavaKogitoBuildContext.builder().build());
        Process process = (Process)parser.getProcessInfo().info();
        ((MapAssert)Assertions.assertThat((Map)process.getMetaData()).containsKey((Object)"Tags")).hasEntrySatisfying((Object)"Tags", tags -> Assertions.assertThat((Object)tags).isInstanceOf(Collection.class));
        Collection tags2 = (Collection)process.getMetaData().get("Tags");
        annotations.forEach(annotation -> Assertions.assertThat((Collection)tags2).anyMatch(tag -> tag.getName().equals(annotation)));
    }

    @Test
    void workflowWithoutAnnotationsShouldResultInProcessWithoutTags() {
        Workflow workflow = ServerlessWorkflowParsingTest.createMinimumWorkflow();
        ServerlessWorkflowParser parser = ServerlessWorkflowParser.of((Workflow)workflow, (KogitoBuildContext)JavaKogitoBuildContext.builder().build());
        Process process = (Process)parser.getProcessInfo().info();
        Assertions.assertThat((Map)process.getMetaData()).doesNotContainKey((Object)"Tags");
    }

    @Test
    void testWorkflowWithDescription() {
        String description = "This is a description";
        String workflowId = "my-workflow";
        Workflow workflow = ServerlessWorkflowParsingTest.createMinimumWorkflow().withId(workflowId).withDescription(description);
        ServerlessWorkflowParser parser = ServerlessWorkflowParser.of((Workflow)workflow, (KogitoBuildContext)JavaKogitoBuildContext.builder().build());
        Process process = (Process)parser.getProcessInfo().info();
        ((MapAssert)Assertions.assertThat((Map)process.getMetaData()).containsKey((Object)"Tags")).hasEntrySatisfying((Object)"Tags", tags -> Assertions.assertThat((Object)tags).isInstanceOf(Collection.class));
        Collection tags2 = (Collection)process.getMetaData().get("Tags");
        Assertions.assertThat((Collection)tags2).anyMatch(tag -> workflowId.equals(tag.getName()) && description.equals(tag.getDescription()));
    }
}

