/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import org.assertj.core.api.Assertions;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.api.definition.process.Node;
import org.kie.kogito.serverless.workflow.AbstractServerlessWorkflowParsingTest;
import org.kie.kogito.serverless.workflow.WorkflowTestUtils;

class SwitchStateServerlessWorkflowParsingTest
extends AbstractServerlessWorkflowParsingTest {
    SwitchStateServerlessWorkflowParsingTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state-data-condition-transition.sw.json", "/exec/switch-state-data-condition-transition.sw.yml"})
    void switchStateDataConditionTransition(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        WorkflowTestUtils.assertProcessMainParams(process, "switch_state_data_condition_transition", "Switch State Data Condition Transition Test", "1.0", "org.kie.kogito.serverless", "Public");
        WorkflowTestUtils.assertHasNodesSize(process, 6);
        StartNode processStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 0, StartNode.class);
        EndNode processEndNode1 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 1, EndNode.class);
        EndNode processEndNode2 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 2, EndNode.class);
        Split splitNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, Split.class);
        WorkflowTestUtils.assertExclusiveSplit(splitNode, "ChooseOnAge", 2);
        WorkflowTestUtils.assertConstraintIsDefault(splitNode, "4_6");
        ActionNode approveTransitionActionNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 4, ActionNode.class);
        WorkflowTestUtils.assertHasName((Node)approveTransitionActionNode, "Approve");
        ActionNode denyTransitionActionNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 5, ActionNode.class);
        WorkflowTestUtils.assertHasName((Node)denyTransitionActionNode, "Deny");
        WorkflowTestUtils.assertIsConnected((Node)processStartNode, (Node)splitNode);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)approveTransitionActionNode);
        WorkflowTestUtils.assertIsConnected((Node)approveTransitionActionNode, (Node)processEndNode1);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)denyTransitionActionNode);
        WorkflowTestUtils.assertIsConnected((Node)denyTransitionActionNode, (Node)processEndNode2);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state-data-condition-end.sw.json", "/exec/switch-state-data-condition-end.sw.yml"})
    void switchStateDataConditionEnd(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        WorkflowTestUtils.assertProcessMainParams(process, "switch_state_data_condition_end", "Switch State Data Condition End Test", "1.0", "org.kie.kogito.serverless", "Public");
        WorkflowTestUtils.assertHasNodesSize(process, 6);
        StartNode processStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 0, StartNode.class);
        ActionNode addInfoActionNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 1, ActionNode.class);
        WorkflowTestUtils.assertHasName((Node)addInfoActionNode, "AddInfo");
        Split splitNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 2, Split.class);
        WorkflowTestUtils.assertExclusiveSplit(splitNode, "ChooseOnAge", 2);
        WorkflowTestUtils.assertConstraintIsDefault(splitNode, "3_5");
        WorkflowTestUtils.assertConstraintIsDefault(splitNode, "3_6");
        EndNode processEndNode1 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, EndNode.class);
        EndNode processEndNode2 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 4, EndNode.class);
        EndNode processEndNode3 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 5, EndNode.class);
        WorkflowTestUtils.assertIsConnected((Node)processStartNode, (Node)addInfoActionNode);
        WorkflowTestUtils.assertIsConnected((Node)addInfoActionNode, (Node)splitNode);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)processEndNode1);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)processEndNode2);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)processEndNode3);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state-event-condition-timeouts-end.sw.json", "/exec/switch-state-event-condition-timeouts-end.sw.yml"})
    void switchStateEventConditionTimeoutsEnd(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        WorkflowTestUtils.assertProcessMainParams(process, "switch_state_event_condition_timeouts_end", "Switch State Event Condition Timeouts End Test", "1.0", "org.kie.kogito.serverless", "Public");
        WorkflowTestUtils.assertHasNodesSize(process, 12);
        StartNode processStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 0, StartNode.class);
        EndNode endNode1 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 1, EndNode.class);
        EndNode endNode2 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 2, EndNode.class);
        Split splitNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, Split.class);
        WorkflowTestUtils.assertHasName((Node)splitNode, "ChooseOnEvent");
        CompositeContextNode approvedVisaState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 4, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)approvedVisaState, "ApprovedVisa");
        CompositeContextNode deniedVisaState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 5, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)deniedVisaState, "DeniedVisa");
        TimerNode timeoutTimerNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 6, TimerNode.class);
        Assertions.assertThat((String)timeoutTimerNode.getTimer().getDelay()).isEqualTo("PT5S");
        EndNode endNode3 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 7, EndNode.class);
        EventNode visaApprovedEventNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 8, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)visaApprovedEventNode, "visaApprovedEvent");
        ActionNode visaApprovedEventNodeMergeAction = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 9, ActionNode.class);
        EventNode visaDeniedEventNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 10, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)visaDeniedEventNode, "visaDeniedEvent");
        ActionNode visaDeniedEventNodeMergeAction = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 11, ActionNode.class);
        WorkflowTestUtils.assertIsConnected((Node)processStartNode, (Node)splitNode);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)timeoutTimerNode);
        WorkflowTestUtils.assertIsConnected((Node)timeoutTimerNode, (Node)endNode3);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)visaApprovedEventNode);
        WorkflowTestUtils.assertIsConnected((Node)visaApprovedEventNode, (Node)visaApprovedEventNodeMergeAction);
        WorkflowTestUtils.assertIsConnected((Node)visaApprovedEventNodeMergeAction, (Node)approvedVisaState);
        WorkflowTestUtils.assertIsConnected((Node)approvedVisaState, (Node)endNode1);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)visaDeniedEventNode);
        WorkflowTestUtils.assertIsConnected((Node)visaDeniedEventNode, (Node)visaDeniedEventNodeMergeAction);
        WorkflowTestUtils.assertIsConnected((Node)visaDeniedEventNodeMergeAction, (Node)deniedVisaState);
        WorkflowTestUtils.assertIsConnected((Node)deniedVisaState, (Node)endNode2);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state-event-condition-timeouts-transition.sw.json", "/exec/switch-state-event-condition-timeouts-transition.sw.yml"})
    void switchStateEventConditionTimeoutsTransition(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        WorkflowTestUtils.assertProcessMainParams(process, "switch_state_event_condition_timeouts_transition", "Switch State Event Condition Timeouts Transition Test", "1.0", "org.kie.kogito.serverless", "Public");
        WorkflowTestUtils.assertHasNodesSize(process, 13);
        StartNode processStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 0, StartNode.class);
        EndNode endNode1 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 1, EndNode.class);
        EndNode endNode2 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 2, EndNode.class);
        EndNode endNode3 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, EndNode.class);
        Split splitNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 4, Split.class);
        WorkflowTestUtils.assertHasName((Node)splitNode, "ChooseOnEvent");
        CompositeContextNode approvedVisaState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 5, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)approvedVisaState, "ApprovedVisa");
        CompositeContextNode deniedVisaState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 6, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)deniedVisaState, "DeniedVisa");
        CompositeContextNode handleNoVisaDecisionState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 7, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)handleNoVisaDecisionState, "HandleNoVisaDecision");
        TimerNode timeoutTimerNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 8, TimerNode.class);
        Assertions.assertThat((String)timeoutTimerNode.getTimer().getDelay()).isEqualTo("PT5S");
        EventNode visaApprovedEvent = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 9, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)visaApprovedEvent, "visaApprovedEvent");
        ActionNode visaApprovedEventNodeMergeAction = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 10, ActionNode.class);
        EventNode visaDeniedEvent = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 11, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)visaDeniedEvent, "visaDeniedEvent");
        ActionNode visaDeniedEventMergeAction = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 12, ActionNode.class);
        WorkflowTestUtils.assertIsConnected((Node)processStartNode, (Node)splitNode);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)visaApprovedEvent);
        WorkflowTestUtils.assertIsConnected((Node)visaApprovedEvent, (Node)visaApprovedEventNodeMergeAction);
        WorkflowTestUtils.assertIsConnected((Node)visaApprovedEventNodeMergeAction, (Node)approvedVisaState);
        WorkflowTestUtils.assertIsConnected((Node)approvedVisaState, (Node)endNode1);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)visaDeniedEvent);
        WorkflowTestUtils.assertIsConnected((Node)visaDeniedEvent, (Node)visaDeniedEventMergeAction);
        WorkflowTestUtils.assertIsConnected((Node)visaDeniedEventMergeAction, (Node)deniedVisaState);
        WorkflowTestUtils.assertIsConnected((Node)deniedVisaState, (Node)endNode2);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)timeoutTimerNode);
        WorkflowTestUtils.assertIsConnected((Node)timeoutTimerNode, (Node)handleNoVisaDecisionState);
        WorkflowTestUtils.assertIsConnected((Node)handleNoVisaDecisionState, (Node)endNode3);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state-event-condition-timeouts-transition2.sw.json", "/exec/switch-state-event-condition-timeouts-transition2.sw.yml"})
    void switchStateEventConditionTimeoutsTransition2(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation);
        WorkflowTestUtils.assertProcessMainParams(process, "switch_state_event_condition_timeouts_transition2", "Switch State Event Condition Timeouts Transition2 Test", "1.0", "org.kie.kogito.serverless", "Public");
        WorkflowTestUtils.assertHasNodesSize(process, 12);
        StartNode processStartNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 0, StartNode.class);
        EndNode endNode1 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 1, EndNode.class);
        EndNode endNode2 = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 2, EndNode.class);
        Split splitNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 3, Split.class);
        WorkflowTestUtils.assertHasName((Node)splitNode, "ChooseOnEvent");
        CompositeContextNode approvedVisaState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 4, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)approvedVisaState, "ApprovedVisa");
        CompositeContextNode deniedVisaState = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 5, CompositeContextNode.class);
        WorkflowTestUtils.assertHasName((Node)deniedVisaState, "DeniedVisa");
        TimerNode timeoutTimerNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 6, TimerNode.class);
        Assertions.assertThat((String)timeoutTimerNode.getTimer().getDelay()).isEqualTo("PT5S");
        EventNode visaApprovedEvent = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 7, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)visaApprovedEvent, "visaApprovedEvent");
        ActionNode visaApprovedEventNodeMergeAction = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 8, ActionNode.class);
        EventNode visaDeniedEvent = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 9, EventNode.class);
        WorkflowTestUtils.assertHasName((Node)visaDeniedEvent, "visaDeniedEvent");
        ActionNode visaDeniedEventMergeAction = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 10, ActionNode.class);
        Join visaDeniedJoinNode = WorkflowTestUtils.assertClassAndGetNode((NodeContainer)process, 11, Join.class);
        WorkflowTestUtils.assertIsConnected((Node)processStartNode, (Node)splitNode);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)visaApprovedEvent);
        WorkflowTestUtils.assertIsConnected((Node)visaApprovedEvent, (Node)visaApprovedEventNodeMergeAction);
        WorkflowTestUtils.assertIsConnected((Node)visaApprovedEventNodeMergeAction, (Node)approvedVisaState);
        WorkflowTestUtils.assertIsConnected((Node)approvedVisaState, (Node)endNode1);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)visaDeniedEvent);
        WorkflowTestUtils.assertIsConnected((Node)visaDeniedEvent, (Node)visaDeniedEventMergeAction);
        WorkflowTestUtils.assertIsConnected((Node)visaDeniedEventMergeAction, (Node)visaDeniedJoinNode);
        WorkflowTestUtils.assertIsConnected((Node)splitNode, (Node)timeoutTimerNode);
        WorkflowTestUtils.assertIsConnected((Node)timeoutTimerNode, (Node)visaDeniedJoinNode);
        WorkflowTestUtils.assertIsConnected((Node)visaDeniedJoinNode, (Node)deniedVisaState);
        WorkflowTestUtils.assertIsConnected((Node)deniedVisaState, (Node)endNode2);
    }
}

