/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.Split;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;

public class WorkflowTestUtils {
    public static final Path resourceDirectory = Paths.get("src", "test", "resources");
    public static final String absolutePath = resourceDirectory.toFile().getAbsolutePath();

    private WorkflowTestUtils() {
    }

    public static Path getResourcePath(String file) {
        return Paths.get(absolutePath + File.separator + file, new String[0]);
    }

    public static InputStream getInputStreamFromPath(Path path) throws Exception {
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public static String readWorkflowFile(String location) {
        return WorkflowTestUtils.readFileAsString(WorkflowTestUtils.classpathResourceReader(location));
    }

    public static Reader classpathResourceReader(String location) {
        return new InputStreamReader(WorkflowTestUtils.class.getResourceAsStream(location));
    }

    public static String readFileAsString(Reader reader) {
        try {
            int numRead;
            StringBuilder fileData = new StringBuilder(1000);
            char[] buf = new char[1024];
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            return fileData.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertProcessMainParams(RuleFlowProcess process, String id, String name, String version, String pkg, String visibility) {
        Assertions.assertThat((String)process.getId()).isEqualTo(id);
        Assertions.assertThat((String)process.getName()).isEqualTo(name);
        Assertions.assertThat((String)process.getVersion()).isEqualTo(version);
        Assertions.assertThat((String)process.getPackageName()).isEqualTo(pkg);
        Assertions.assertThat((String)process.getVisibility()).isEqualTo(visibility);
    }

    public static void assertHasName(Node node, String expectedName) {
        ((AbstractStringAssert)Assertions.assertThat((String)node.getName()).withFailMessage("Node: (%s, %s) is expected to have name: %s", new Object[]{node.getId(), node.getName(), expectedName})).isEqualTo(expectedName);
    }

    public static void assertExclusiveSplit(Split splitNode, String name, int constrainsSize) {
        WorkflowTestUtils.assertHasName((Node)splitNode, name);
        Assertions.assertThat((Map)splitNode.getConstraints()).hasSize(constrainsSize);
        Assertions.assertThat((int)splitNode.getType()).isEqualTo(2);
    }

    public static <T extends Node> T assertClassAndGetNode(NodeContainer nodeContainer, int nodeIndex, Class<T> expectedNodeClass) {
        Node node = nodeContainer.getNodes()[nodeIndex];
        ((ObjectArrayAssert)Assertions.assertThat((Object[])nodeContainer.getNodes()).withFailMessage("Required nodeIndex: %s is out of range, the nodeContainer.nodes has size: %s.", new Object[]{nodeIndex, nodeContainer.getNodes().length})).hasSizeGreaterThan(nodeIndex);
        ((ObjectAssert)Assertions.assertThat((Object)node).withFailMessage("Node at nodeIndex: %s must be of class: %s, but is: %s.", new Object[]{nodeIndex, expectedNodeClass.getName(), node.getClass().getName()})).isInstanceOf(expectedNodeClass);
        return (T)node;
    }

    public static void assertIsConnected(Node startNode, Node endNode) {
        ((MapAssert)Assertions.assertThat((Map)startNode.getOutgoingConnections()).withFailMessage("Node: (%s, %s), has no outgoing connections.", new Object[]{startNode.getId(), startNode.getName()})).hasSizeGreaterThan(0);
        for (List connections : startNode.getOutgoingConnections().values()) {
            for (Connection connection : connections) {
                if (connection.getTo() != endNode) continue;
                return;
            }
        }
        Assertions.fail((String)"Node: (%s, %s), is not connected with Node: (%s, %s).", (Object[])new Object[]{startNode.getId(), startNode.getName(), endNode.getId(), endNode.getName()});
    }

    public static void assertHasNodesSize(CompositeContextNode compositeContextNode, int expectedSize) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])compositeContextNode.getNodes()).withFailMessage("Node: (%s, %s), is expected to have %s nodes, but has %s.", new Object[]{compositeContextNode.getId(), compositeContextNode.getName(), expectedSize, compositeContextNode.getNodes().length})).hasSize(expectedSize);
    }

    public static void assertHasNodesSize(RuleFlowProcess process, int expectedSize) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])process.getNodes()).withFailMessage("Process: (%s, %s), is expected to have %s nodes, but has %s.", new Object[]{process.getId(), process.getName(), expectedSize, process.getNodes().length})).hasSize(expectedSize);
    }

    public static void assertConstraintIsDefault(Split splitNode, String constraintName) {
        Constraint constraint = splitNode.getConstraints().values().stream().filter(c -> constraintName.equals(c.getName())).findFirst().orElse(null);
        ((ObjectAssert)Assertions.assertThat((Object)constraint).withFailMessage("No constraint with name: %s was found for the splitNode: %s", new Object[]{constraintName, splitNode.getId()})).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Objects.requireNonNull(constraint).isDefault()).withFailMessage("Constraint with name: %s is not marked as default", new Object[]{constraintName})).isTrue();
    }
}

