/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.operationid;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.net.URI;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationId;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactoryType;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;
import org.mockito.Mockito;

class FullURIWorkflowOperationIdTest {
    private Workflow workflow;
    private FunctionDefinition definition;

    FullURIWorkflowOperationIdTest() {
    }

    @BeforeEach
    void setup() {
        this.workflow = (Workflow)Mockito.mock(Workflow.class);
        this.definition = new FunctionDefinition("pepe");
    }

    @Test
    void testOperationId() {
        this.definition.setType(FunctionDefinition.Type.REST);
        this.definition.setOperation("http://myserver.com/spec/PePE1.yaml#doSomething");
        WorkflowOperationId id = WorkflowOperationIdFactoryType.FULL_URI.factory().from(this.workflow, this.definition, Optional.empty());
        Assertions.assertThat((String)id.getOperation()).isEqualTo("doSomething");
        Assertions.assertThat((String)id.getFileName()).isEqualTo("/spec/PePE1.yaml");
        Assertions.assertThat((String)ServerlessWorkflowUtils.getOpenApiWorkItemName((String)id.getFileName(), (String)id.getOperation())).isEqualTo("/spec/PePE1_doSomething");
        Assertions.assertThat((String)id.getPackageName()).isEqualTo("specpepe");
        Assertions.assertThat((URI)id.getUri()).hasToString("http://myserver.com/spec/PePE1.yaml");
        Assertions.assertThat((String)id.getService()).isNull();
    }
}

