/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.operationid;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.net.URI;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationId;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactoryType;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;
import org.mockito.Mockito;

class FunctionOperationIdTest {
    private Workflow workflow;
    private FunctionDefinition definition;

    FunctionOperationIdTest() {
    }

    @BeforeEach
    void setup() {
        this.workflow = (Workflow)Mockito.mock(Workflow.class);
        Mockito.when((Object)this.workflow.getId()).thenReturn((Object)"Test");
        this.definition = new FunctionDefinition("function1");
    }

    @Test
    void testOperationId() {
        this.definition.setType(FunctionDefinition.Type.REST);
        this.definition.setOperation("specs/external-service.yaml#sendRequest");
        WorkflowOperationId id = WorkflowOperationIdFactoryType.FUNCTION_NAME.factory().from(this.workflow, this.definition, Optional.empty());
        Assertions.assertThat((String)id.getOperation()).isEqualTo("sendRequest");
        Assertions.assertThat((String)id.getFileName()).isEqualTo("Test_function1");
        Assertions.assertThat((String)id.getPackageName()).isEqualTo("testfunction");
        Assertions.assertThat((String)ServerlessWorkflowUtils.getOpenApiWorkItemName((String)id.getFileName(), (String)id.getOperation())).isEqualTo("Test_function1_sendRequest");
        Assertions.assertThat((URI)id.getUri()).hasToString("specs/external-service.yaml");
        Assertions.assertThat((String)id.getService()).isNull();
    }
}

