/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.operationid;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.net.URI;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationId;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactoryType;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;
import org.mockito.Mockito;

class SpecTitleOperationIdTest {
    private Workflow workflow;
    private FunctionDefinition definition;

    SpecTitleOperationIdTest() {
    }

    @BeforeEach
    void setup() {
        this.workflow = (Workflow)Mockito.mock(Workflow.class);
        this.definition = new FunctionDefinition("pepe");
    }

    @Test
    void testOperationId() {
        this.definition.setType(FunctionDefinition.Type.REST);
        this.definition.setOperation("specs/external-service.yaml#sendRequest");
        WorkflowOperationId id = WorkflowOperationIdFactoryType.SPEC_TITLE.factory().from(this.workflow, this.definition, Optional.empty());
        Assertions.assertThat((String)id.getOperation()).isEqualTo("sendRequest");
        Assertions.assertThat((String)id.getFileName()).isEqualTo("external-service");
        Assertions.assertThat((String)id.getPackageName()).isEqualTo("externalservice");
        Assertions.assertThat((String)ServerlessWorkflowUtils.getOpenApiWorkItemName((String)id.getFileName(), (String)id.getOperation())).isEqualTo("external-service_sendRequest");
        Assertions.assertThat((URI)id.getUri()).hasToString("specs/external-service.yaml");
        Assertions.assertThat((String)id.getService()).isNull();
    }
}

