/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser.handlers.validation;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.defaultdef.DefaultConditionDefinition;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.states.SwitchState;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.transitions.Transition;
import java.util.ArrayList;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.handlers.StateHandler;
import org.kie.kogito.serverless.workflow.parser.handlers.validation.SwitchValidator;
import org.mockito.Mockito;

class SwitchValidatorTest {
    private static final String WORKFLOW_NAME = "WORKFLOW_NAME";
    private static final String SWITCH_STATE_NAME = "SWITCH_STATE_NAME";
    private static final String NEXT_STATE = "NEXT_STATE";
    private Workflow workflow;
    private SwitchState switchState;
    private ParserContext parserContext;

    SwitchValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.workflow = this.mockWorkflow();
        this.switchState = this.mockSwitchState();
        this.parserContext = (ParserContext)Mockito.mock(ParserContext.class);
    }

    @Test
    void validateConditionsNoConditionsFoundError() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SwitchValidator.validateConditions((SwitchState)this.switchState, (Workflow)this.workflow)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("No dataConditions or eventConditions where found for the switch state \"%s\" that belongs to the serverless workflow: \"%s\".", SWITCH_STATE_NAME, WORKFLOW_NAME));
    }

    @Test
    void validateConditionsBothConditionsFoundError() {
        this.switchState.getDataConditions().add((DataCondition)Mockito.mock(DataCondition.class));
        this.switchState.getEventConditions().add((EventCondition)Mockito.mock(EventCondition.class));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SwitchValidator.validateConditions((SwitchState)this.switchState, (Workflow)this.workflow)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("DataConditions and eventConditions where found at the same time for the switch state \"%s\" that belongs to the serverless workflow: \"%s\".", SWITCH_STATE_NAME, WORKFLOW_NAME));
    }

    @Test
    void validateDefaultConditionTransitionWithoutNextError() {
        DefaultConditionDefinition defaultCondition = SwitchValidatorTest.mockDefaultConditionWithTransition();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SwitchValidator.validateDefaultCondition((DefaultConditionDefinition)defaultCondition, (SwitchState)this.switchState, (Workflow)this.workflow, (ParserContext)this.parserContext)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("The \"nextState\" is required for the \"defaultCondition\" transition in the switch state \"%s\" that belongs to the serverless workflow: \"%s\".", SWITCH_STATE_NAME, WORKFLOW_NAME));
    }

    @Test
    void validateDefaultConditionTransitionNextStateNotFoundError() {
        DefaultConditionDefinition defaultCondition = SwitchValidatorTest.mockDefaultConditionWithTransition();
        Transition transition = defaultCondition.getTransition();
        ((Transition)Mockito.doReturn((Object)NEXT_STATE).when((Object)transition)).getNextState();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SwitchValidator.validateDefaultCondition((DefaultConditionDefinition)defaultCondition, (SwitchState)this.switchState, (Workflow)this.workflow, (ParserContext)this.parserContext)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("The \"nextState\" : \"%s\" configured for the \"defaultCondition\" transition in the switch state \"%s\", was not found in the serverless workflow: \"%s\".", NEXT_STATE, SWITCH_STATE_NAME, WORKFLOW_NAME));
    }

    @Test
    void validateDefaultConditionWithoutTransitionAndEndIsNullError() {
        DefaultConditionDefinition defaultCondition = (DefaultConditionDefinition)Mockito.mock(DefaultConditionDefinition.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SwitchValidator.validateDefaultCondition((DefaultConditionDefinition)defaultCondition, (SwitchState)this.switchState, (Workflow)this.workflow, (ParserContext)this.parserContext)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("The \"defaultCondition\" in the switch state \"%s\" that belongs to the serverless workflow: \"%s\", must either have a configured \"transition\" or be set as \"end\" : true.", SWITCH_STATE_NAME, WORKFLOW_NAME));
    }

    @Test
    void validateDefaultConditionWithEventConditionsTransitionButTimeoutNotSetError() {
        this.switchState.getEventConditions().add((EventCondition)Mockito.mock(EventCondition.class));
        DefaultConditionDefinition defaultCondition = SwitchValidatorTest.mockDefaultConditionWithTransition();
        Transition transition = defaultCondition.getTransition();
        ((Transition)Mockito.doReturn((Object)NEXT_STATE).when((Object)transition)).getNextState();
        StateHandler stateHandler = (StateHandler)Mockito.mock(StateHandler.class);
        ((ParserContext)Mockito.doReturn((Object)stateHandler).when((Object)this.parserContext)).getStateHandler(NEXT_STATE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SwitchValidator.validateDefaultCondition((DefaultConditionDefinition)defaultCondition, (SwitchState)this.switchState, (Workflow)this.workflow, (ParserContext)this.parserContext)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("The \"eventTimeout\" configuration is required for the \"eventConditions\" based switch state \"%s\" that belongs to the serverless workflow: \"%s\".", SWITCH_STATE_NAME, WORKFLOW_NAME));
    }

    @Test
    void validateDefaultConditionWithEventConditionsEndButTimeoutNotSetError() {
        this.switchState.getEventConditions().add((EventCondition)Mockito.mock(EventCondition.class));
        DefaultConditionDefinition defaultCondition = (DefaultConditionDefinition)Mockito.mock(DefaultConditionDefinition.class);
        End end = (End)Mockito.mock(End.class);
        ((DefaultConditionDefinition)Mockito.doReturn((Object)end).when((Object)defaultCondition)).getEnd();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SwitchValidator.validateDefaultCondition((DefaultConditionDefinition)defaultCondition, (SwitchState)this.switchState, (Workflow)this.workflow, (ParserContext)this.parserContext)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("The \"eventTimeout\" configuration is required for the \"eventConditions\" based switch state \"%s\" that belongs to the serverless workflow: \"%s\".", SWITCH_STATE_NAME, WORKFLOW_NAME));
    }

    private SwitchState mockSwitchState() {
        SwitchState switchState = (SwitchState)Mockito.mock(SwitchState.class);
        ((SwitchState)Mockito.doReturn((Object)SWITCH_STATE_NAME).when((Object)switchState)).getName();
        ArrayList dataConditions = new ArrayList();
        ((SwitchState)Mockito.doReturn(dataConditions).when((Object)switchState)).getDataConditions();
        ArrayList eventConditions = new ArrayList();
        ((SwitchState)Mockito.doReturn(eventConditions).when((Object)switchState)).getEventConditions();
        return switchState;
    }

    private Workflow mockWorkflow() {
        Workflow workflow = (Workflow)Mockito.mock(Workflow.class);
        ((Workflow)Mockito.doReturn((Object)WORKFLOW_NAME).when((Object)workflow)).getName();
        return workflow;
    }

    private static DefaultConditionDefinition mockDefaultConditionWithTransition() {
        DefaultConditionDefinition defaultCondition = (DefaultConditionDefinition)Mockito.mock(DefaultConditionDefinition.class);
        Transition transition = (Transition)Mockito.mock(Transition.class);
        ((DefaultConditionDefinition)Mockito.doReturn((Object)transition).when((Object)defaultCondition)).getTransition();
        return defaultCondition;
    }
}

