/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.serverless.workflow.utils.TimeoutsConfigResolver;
import org.mockito.Mockito;

class TimeoutsConfigResolverTest {
    private static final String STATE_NAME = "STATE_NAME";
    private static final String WORKFLOW_NAME = "WORKFLOW_NAME";
    private static final String VALID_STATE_TIMEOUT_DURATION = "PT1M";
    private static final String VALID_WORKFLOW_TIMEOUT_DURATION = "PT8M";
    private static final String INVALID_STATE_TIMEOUT_DURATION = "INVALID_STATE_TIMEOUT_DURATION";
    private static final String EMPTY_STATE_TIMEOUT_DURATION = "";
    private static final String INVALID_WORKFLOW_TIMEOUT_DURATION = "INVALID_WORKFLOW_TIMEOUT_DURATION";
    private static final String EMPTY_WORKFLOW_TIMEOUT_DURATION = "";

    TimeoutsConfigResolverTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"successfulCaseParams"})
    void resolveEventTimeoutSuccessful(State state, Workflow workflow, String expectedTimeout) {
        Assertions.assertThat((String)TimeoutsConfigResolver.resolveEventTimeout((State)state, (Workflow)workflow)).isEqualTo(expectedTimeout);
    }

    static Stream<Arguments> successfulCaseParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME), null}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, null), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, null), null}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, VALID_STATE_TIMEOUT_DURATION), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME), VALID_STATE_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, VALID_STATE_TIMEOUT_DURATION), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, null), VALID_STATE_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, VALID_STATE_TIMEOUT_DURATION), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, VALID_WORKFLOW_TIMEOUT_DURATION), VALID_STATE_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, VALID_WORKFLOW_TIMEOUT_DURATION), VALID_WORKFLOW_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, null), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, VALID_WORKFLOW_TIMEOUT_DURATION), VALID_WORKFLOW_TIMEOUT_DURATION}));
    }

    @ParameterizedTest
    @MethodSource(value={"unsuccessfulCaseParams"})
    void resolveEventTimeoutUnsuccessful(State state, Workflow workflow, String expectedMessagePart) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimeoutsConfigResolver.resolveEventTimeout((State)state, (Workflow)workflow)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(expectedMessagePart);
    }

    static Stream<Arguments> unsuccessfulCaseParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, INVALID_STATE_TIMEOUT_DURATION), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME), INVALID_STATE_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, ""), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME), ""}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, INVALID_STATE_TIMEOUT_DURATION), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, null), INVALID_STATE_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, INVALID_STATE_TIMEOUT_DURATION), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, INVALID_WORKFLOW_TIMEOUT_DURATION), INVALID_STATE_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, INVALID_STATE_TIMEOUT_DURATION), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, VALID_WORKFLOW_TIMEOUT_DURATION), INVALID_STATE_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, INVALID_WORKFLOW_TIMEOUT_DURATION), INVALID_WORKFLOW_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, ""), ""}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, null), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, INVALID_WORKFLOW_TIMEOUT_DURATION), INVALID_WORKFLOW_TIMEOUT_DURATION}), Arguments.of((Object[])new Object[]{TimeoutsConfigResolverTest.mockState(STATE_NAME, null), TimeoutsConfigResolverTest.mockWorkflow(WORKFLOW_NAME, INVALID_WORKFLOW_TIMEOUT_DURATION), INVALID_WORKFLOW_TIMEOUT_DURATION}));
    }

    private static State mockState(String name) {
        State state = (State)Mockito.mock(State.class);
        ((State)Mockito.doReturn((Object)name).when((Object)state)).getName();
        return state;
    }

    private static State mockState(String name, String eventTimeout) {
        State state = TimeoutsConfigResolverTest.mockState(name);
        TimeoutsDefinition timeoutsDefinition = TimeoutsConfigResolverTest.mockTimeoutsDefinition(eventTimeout);
        ((State)Mockito.doReturn((Object)timeoutsDefinition).when((Object)state)).getTimeouts();
        return state;
    }

    private static Workflow mockWorkflow(String name) {
        Workflow workflow = (Workflow)Mockito.mock(Workflow.class);
        ((Workflow)Mockito.doReturn((Object)name).when((Object)workflow)).getName();
        return workflow;
    }

    private static Workflow mockWorkflow(String name, String eventTimeout) {
        Workflow workflow = TimeoutsConfigResolverTest.mockWorkflow(name);
        TimeoutsDefinition timeoutsDefinition = TimeoutsConfigResolverTest.mockTimeoutsDefinition(eventTimeout);
        ((Workflow)Mockito.doReturn((Object)timeoutsDefinition).when((Object)workflow)).getTimeouts();
        return workflow;
    }

    private static TimeoutsDefinition mockTimeoutsDefinition(String eventTimeout) {
        TimeoutsDefinition timeoutsDefinition = (TimeoutsDefinition)Mockito.mock(TimeoutsDefinition.class);
        ((TimeoutsDefinition)Mockito.doReturn((Object)eventTimeout).when((Object)timeoutsDefinition)).getEventTimeout();
        return timeoutsDefinition;
    }
}

