/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.mapper.BaseObjectMapper;
import io.serverlessworkflow.api.mapper.JsonObjectMapper;
import io.serverlessworkflow.api.mapper.YamlObjectMapper;
import java.io.File;
import java.util.Collections;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class WorkflowUtilsTest {
    private static final String TEST_RESOURCES = "src/test/resources";
    KogitoBuildContext context;

    @BeforeEach
    protected void setup() {
        this.context = JavaKogitoBuildContext.builder().withApplicationProperties(new File[]{new File(TEST_RESOURCES)}).withPackageName(this.getClass().getPackage().getName()).build();
    }

    @Test
    public void testGetObjectMapper() {
        BaseObjectMapper objectMapper = ServerlessWorkflowUtils.getObjectMapper((String)"json");
        ((ObjectAssert)Assertions.assertThat((Object)objectMapper).isNotNull()).isInstanceOf(JsonObjectMapper.class);
        objectMapper = ServerlessWorkflowUtils.getObjectMapper((String)"yml");
        ((ObjectAssert)Assertions.assertThat((Object)objectMapper).isNotNull()).isInstanceOf(YamlObjectMapper.class);
    }

    @Test
    public void testResolveFunctionMetadata() {
        FunctionDefinition function = new FunctionDefinition().withName("testfunction1").withMetadata(Collections.singletonMap("testprop1", "customtestprop1val"));
        ((AbstractStringAssert)Assertions.assertThat((String)ServerlessWorkflowUtils.resolveFunctionMetadata((FunctionDefinition)function, (String)"testprop1", (KogitoBuildContext)this.context)).isNotNull()).isEqualTo("customtestprop1val");
        ((AbstractStringAssert)Assertions.assertThat((String)ServerlessWorkflowUtils.resolveFunctionMetadata((FunctionDefinition)function, (String)"testprop2", (KogitoBuildContext)this.context)).isNotNull()).isEqualTo("testprop2val");
    }

    @Test
    public void testResolveOpenAPIMetadata() {
        Assertions.assertThat((String)((String)ServerlessWorkflowUtils.getOpenApiProperty((String)"testfunction", (String)"base_path", (KogitoBuildContext)this.context, String.class, (Object)"http://localhost:8080"))).isEqualTo("http://localhost:8282");
        Assertions.assertThat((Integer)((Integer)ServerlessWorkflowUtils.getOpenApiProperty((String)"testfunction1", (String)"base_path2", (KogitoBuildContext)this.context, Integer.class, (Object)0))).isZero();
    }
}

