/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event;

import java.util.UUID;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.services.event.DataEventAttrBuilder;
import org.mockito.Mockito;

class DataEventAttrBuilderTest {
    DataEventAttrBuilderTest() {
    }

    @Test
    void verifyEventSourceBeingGenerated() {
        String processId = "the_cool_project";
        String instanceId = UUID.randomUUID().toString();
        KogitoProcessInstance pi = (KogitoProcessInstance)Mockito.mock(KogitoProcessInstance.class);
        Mockito.when((Object)pi.getProcessId()).thenReturn((Object)"the_cool_project");
        Mockito.when((Object)pi.getStringId()).thenReturn((Object)instanceId);
        String source = DataEventAttrBuilder.toSource((KogitoProcessInstance)pi);
        ((AbstractStringAssert)Assertions.assertThat((String)source).isNotBlank()).contains(new CharSequence[]{"the_cool_project"});
    }

    @Test
    void verifyEventTypeBeingGenerated() {
        String channelName = "github";
        String processId = "the_cool_project";
        String type = DataEventAttrBuilder.toType((String)"github", (String)"the_cool_project");
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)type).isNotBlank()).contains(new CharSequence[]{"the_cool_project"})).contains(new CharSequence[]{"github"})).startsWith((CharSequence)"process");
    }

    @Test
    void verifyEventTypeBeingGeneratedWithProcessInstance() {
        String channelName = "github";
        String processId = "COOL_PROJECT";
        KogitoProcessInstance pi = (KogitoProcessInstance)Mockito.mock(KogitoProcessInstance.class);
        Mockito.when((Object)pi.getProcessId()).thenReturn((Object)"COOL_PROJECT");
        String type = DataEventAttrBuilder.toType((String)"github", (KogitoProcessInstance)pi);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)type).isNotBlank()).doesNotContain(new CharSequence[]{"COOL_PROJECT"})).contains(new CharSequence[]{"COOL_PROJECT".toLowerCase()})).contains(new CharSequence[]{"github"})).startsWith((CharSequence)"process");
    }
}

