/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.Signal;
import org.kie.kogito.services.jobs.impl.TriggerJobCommand;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TriggerJobCommandTest {
    private static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    private static final String TIMER_ID = "TIMER:1:8be48533-beed-4c7b-ad85-bd7b543e7925";
    private static final int LIMIT = 1;
    @Mock
    private UnitOfWorkManager unitOfWorkManager;
    @Mock
    private UnitOfWork unitOfWork;
    @Mock
    private Process<?> process;
    @Mock
    private ProcessInstances<?> instances;
    @Mock
    private ProcessInstance<?> processInstance;
    private TriggerJobCommand command;

    TriggerJobCommandTest() {
    }

    @BeforeEach
    void setUp() {
        this.command = new TriggerJobCommand(PROCESS_INSTANCE_ID, TIMER_ID, Integer.valueOf(1), this.process, this.unitOfWorkManager);
    }

    @Test
    void executeWhenProcessInstanceNotFound() {
        ((UnitOfWorkManager)Mockito.doReturn((Object)this.unitOfWork).when((Object)this.unitOfWorkManager)).newUnitOfWork();
        ((Process)Mockito.doReturn(this.instances).when(this.process)).instances();
        ((ProcessInstances)Mockito.doReturn(Optional.empty()).when(this.instances)).findById(PROCESS_INSTANCE_ID);
        Assertions.assertThat((boolean)this.command.execute()).isFalse();
    }

    @Test
    void executeWhenProcessInstanceFound() {
        ((UnitOfWorkManager)Mockito.doReturn((Object)this.unitOfWork).when((Object)this.unitOfWorkManager)).newUnitOfWork();
        ((Process)Mockito.doReturn(this.instances).when(this.process)).instances();
        ((ProcessInstances)Mockito.doReturn(Optional.of(this.processInstance)).when(this.instances)).findById(PROCESS_INSTANCE_ID);
        Assertions.assertThat((boolean)this.command.execute()).isTrue();
        ((ProcessInstance)Mockito.verify(this.processInstance)).send((Signal)ArgumentMatchers.any());
    }
}

