/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.services.uow.BaseWorkUnit;
import org.kie.kogito.services.uow.CollectingUnitOfWork;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.services.uow.ManagedUnitOfWork;
import org.kie.kogito.services.uow.PassThroughUnitOfWork;
import org.kie.kogito.services.uow.ProcessInstanceWorkUnit;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.WorkUnit;
import org.kie.kogito.uow.events.UnitOfWorkAbortEvent;
import org.kie.kogito.uow.events.UnitOfWorkEndEvent;
import org.kie.kogito.uow.events.UnitOfWorkEventListener;
import org.kie.kogito.uow.events.UnitOfWorkStartEvent;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultUnitOfWorkManagerTest {
    private UnitOfWorkManager unitOfWorkManager;
    private UnitOfWorkEventListener listener = (UnitOfWorkEventListener)Mockito.mock(UnitOfWorkEventListener.class);

    @BeforeEach
    public void setup() {
        this.unitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
        this.unitOfWorkManager.register(this.listener);
    }

    @Test
    public void testFallbackUnitOfWork() {
        UnitOfWork unit = this.unitOfWorkManager.currentUnitOfWork();
        ((ObjectAssert)Assertions.assertThat((Object)unit).isNotNull()).isInstanceOf(PassThroughUnitOfWork.class);
    }

    @Test
    public void testUnitOfWorkStartEnd() {
        UnitOfWork unit = this.unitOfWorkManager.newUnitOfWork();
        ((ObjectAssert)Assertions.assertThat((Object)unit).isNotNull()).isInstanceOf(ManagedUnitOfWork.class);
        Assertions.assertThat((Object)((ManagedUnitOfWork)unit).delegate()).isInstanceOf(CollectingUnitOfWork.class);
        AtomicInteger counter = new AtomicInteger(0);
        Assertions.assertThat((AtomicInteger)counter).hasValue(0);
        BaseWorkUnit dummyWork = new BaseWorkUnit((Object)counter, d -> ((AtomicInteger)d).incrementAndGet());
        unit.start();
        unit.intercept((WorkUnit)dummyWork);
        unit.end();
        Assertions.assertThat((AtomicInteger)counter).hasValue(1);
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener)).onBeforeStartEvent((UnitOfWorkStartEvent)ArgumentMatchers.any());
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener)).onAfterEndEvent((UnitOfWorkEndEvent)ArgumentMatchers.any());
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onAfterAbortEvent((UnitOfWorkAbortEvent)ArgumentMatchers.any());
    }

    @Test
    public void testUnitOfWorkStartAbort() {
        UnitOfWork unit = this.unitOfWorkManager.newUnitOfWork();
        ((ObjectAssert)Assertions.assertThat((Object)unit).isNotNull()).isInstanceOf(ManagedUnitOfWork.class);
        AtomicInteger counter = new AtomicInteger(0);
        Assertions.assertThat((AtomicInteger)counter).hasValue(0);
        BaseWorkUnit dummyWork = new BaseWorkUnit((Object)counter, d -> ((AtomicInteger)d).incrementAndGet());
        unit.start();
        unit.intercept((WorkUnit)dummyWork);
        unit.abort();
        Assertions.assertThat((AtomicInteger)counter).hasValue(0);
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener)).onBeforeStartEvent((UnitOfWorkStartEvent)ArgumentMatchers.any());
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onAfterEndEvent((UnitOfWorkEndEvent)ArgumentMatchers.any());
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener)).onAfterAbortEvent((UnitOfWorkAbortEvent)ArgumentMatchers.any());
    }

    @Test
    public void testUnitOfWorkStartOnFinishedUnit() {
        UnitOfWork unit = this.unitOfWorkManager.newUnitOfWork();
        ((ObjectAssert)Assertions.assertThat((Object)unit).isNotNull()).isInstanceOf(ManagedUnitOfWork.class);
        unit.start();
        unit.abort();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> unit.start(), (String)"Cannot start already completed unit");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> unit.end(), (String)"Cannot end already completed unit");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> unit.abort(), (String)"Cannot abort already completed unit");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> unit.intercept(null), (String)"Cannot intercept on already completed unit");
    }

    @Test
    public void testUnitOfWorkAddWorkOnNotStarted() {
        UnitOfWork unit = this.unitOfWorkManager.newUnitOfWork();
        ((ObjectAssert)Assertions.assertThat((Object)unit).isNotNull()).isInstanceOf(ManagedUnitOfWork.class);
        AtomicInteger counter = new AtomicInteger(0);
        Assertions.assertThat((AtomicInteger)counter).hasValue(0);
        WorkUnit dummyWork = WorkUnit.create((Object)counter, d -> d.incrementAndGet());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> unit.intercept(dummyWork), (String)"Cannot intercept on not started unit");
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onBeforeStartEvent((UnitOfWorkStartEvent)ArgumentMatchers.any());
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onAfterEndEvent((UnitOfWorkEndEvent)ArgumentMatchers.any());
        ((UnitOfWorkEventListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onAfterAbortEvent((UnitOfWorkAbortEvent)ArgumentMatchers.any());
    }

    @Test
    public void testUnitOfWorkStartEndOrdered() {
        UnitOfWork unit = this.unitOfWorkManager.newUnitOfWork();
        ((ObjectAssert)Assertions.assertThat((Object)unit).isNotNull()).isInstanceOf(ManagedUnitOfWork.class);
        Assertions.assertThat((Object)((ManagedUnitOfWork)unit).delegate()).isInstanceOf(CollectingUnitOfWork.class);
        AtomicInteger counter = new AtomicInteger(0);
        Assertions.assertThat((AtomicInteger)counter).hasValue(0);
        AtomicInteger picounter = new AtomicInteger(0);
        BaseWorkUnit dummyWork = new BaseWorkUnit((Object)counter, d -> ((AtomicInteger)d).incrementAndGet());
        ProcessInstanceWorkUnit piWork = new ProcessInstanceWorkUnit(null, d -> picounter.set(counter.get()));
        unit.start();
        unit.intercept((WorkUnit)dummyWork);
        unit.intercept((WorkUnit)piWork);
        unit.end();
        Assertions.assertThat((AtomicInteger)counter).hasValue(1);
        Assertions.assertThat((AtomicInteger)picounter).hasValue(0);
    }
}

