/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.flexible.ItemDescription;
import org.kie.kogito.process.flexible.Milestone;
import org.kie.kogito.services.event.impl.MilestoneEventBody;
import org.kie.kogito.services.event.impl.ProcessInstanceEventBatch;
import org.mockito.Mockito;

public class ProcessInstanceEventBatchTest {
    @Test
    public void testNoServiceDefined() {
        ProcessInstanceEventBatch batch = new ProcessInstanceEventBatch("", null);
        Assertions.assertThat((String)batch.extractRuntimeSource(Collections.singletonMap("kogito.processinstance.processId", "travels"))).isEqualTo("/travels");
        Assertions.assertThat((String)batch.extractRuntimeSource(Collections.singletonMap("kogito.processinstance.processId", "demo.orders"))).isEqualTo("/orders");
    }

    @Test
    public void testNoProcessIdDefined() {
        ProcessInstanceEventBatch batch = new ProcessInstanceEventBatch("http://localhost:8080", null);
        Assertions.assertThat((String)batch.extractRuntimeSource(Collections.emptyMap())).isNull();
    }

    @Test
    public void testServiceDefined() {
        ProcessInstanceEventBatch batch = new ProcessInstanceEventBatch("http://localhost:8080", null);
        Assertions.assertThat((String)batch.extractRuntimeSource(Collections.singletonMap("kogito.processinstance.processId", "travels"))).isEqualTo("http://localhost:8080/travels");
        Assertions.assertThat((String)batch.extractRuntimeSource(Collections.singletonMap("kogito.processinstance.processId", "demo.orders"))).isEqualTo("http://localhost:8080/orders");
    }

    @Test
    public void testMilestones() {
        ProcessInstanceEventBatch batch = new ProcessInstanceEventBatch(null, null);
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)Mockito.mock(KogitoWorkflowProcessInstance.class);
        Mockito.when((Object)pi.milestones()).thenReturn(null);
        Assertions.assertThat((Iterable)batch.createMilestones(pi)).isNull();
        Mockito.when((Object)pi.milestones()).thenReturn(Collections.emptyList());
        Assertions.assertThat((Iterable)batch.createMilestones(pi)).isEmpty();
        Milestone milestone = Milestone.builder().withId("id").withName("name").withStatus(ItemDescription.Status.AVAILABLE).build();
        Mockito.when((Object)pi.milestones()).thenReturn(Collections.singleton(milestone));
        MilestoneEventBody milestoneEventBody = MilestoneEventBody.create().id("id").name("name").status(ItemDescription.Status.AVAILABLE.name()).build();
        Assertions.assertThat((Iterable)batch.createMilestones(pi)).containsOnly((Object[])new MilestoneEventBody[]{milestoneEventBody});
    }
}

