/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.springboot.InfinispanSpringBootTestResource;
import org.mockito.Mockito;

public class InfinispanSpringBootTestResourceTest {
    private static final String IMAGE = "my-infinispan-image";
    private InfinispanSpringBootTestResource resource;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.infinispan", IMAGE);
        this.givenResource();
    }

    @Test
    public void shouldGetProperty() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resource.getProperties().get("infinispan.remote.server-list"));
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenResource() {
        this.resource = new InfinispanSpringBootTestResource();
    }

    private void givenConditionalResource() {
        this.resource = (InfinispanSpringBootTestResource)Mockito.spy((Object)new InfinispanSpringBootTestResource.Conditional());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

