/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.testcontainers.springboot.KafkaSpringBootTestResource;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class KafkaSpringBootTestResourceTest {
    private KafkaSpringBootTestResource resource;
    private static final String IMAGE = "vectorized/redpanda:latest";

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.kafka", IMAGE);
    }

    @Test
    public void shouldGetProperty() {
        this.givenResource();
        Assertions.assertThrows(IllegalStateException.class, () -> this.resource.getProperties().get("spring.kafka.bootstrap-servers"));
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    private void givenConditionalResource() {
        this.resource = (KafkaSpringBootTestResource)Mockito.spy((Object)new KafkaSpringBootTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (KafkaSpringBootTestResource)Mockito.spy((Object)new KafkaSpringBootTestResource());
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

