/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.KogitoInfinispanContainer;
import org.mockito.Mockito;

public class InfinispanContainerTest {
    private static final int MAPPED_PORT = 11111;
    private static final String IMAGE = "my-infinispan-image";
    private KogitoInfinispanContainer container;

    @BeforeEach
    public void setup() {
        System.setProperty("container.image.infinispan", IMAGE);
        this.container = (KogitoInfinispanContainer)Mockito.spy((Object)new KogitoInfinispanContainer());
        ((KogitoInfinispanContainer)Mockito.doNothing().when((Object)this.container)).start();
        ((KogitoInfinispanContainer)Mockito.doNothing().when((Object)this.container)).setDockerImageName(IMAGE);
    }

    @Test
    public void shouldAddDefaultSettings() {
        Assertions.assertTrue((boolean)this.container.getExposedPorts().contains(11222));
        Assertions.assertEquals((Object)"admin", this.container.getEnvMap().get("USER"));
        Assertions.assertEquals((Object)"admin", this.container.getEnvMap().get("PASS"));
    }

    @Test
    public void shouldGetResourceName() {
        Assertions.assertEquals((Object)"infinispan", (Object)this.container.getResourceName());
    }

    @Test
    public void shouldGetMapperPort() {
        ((KogitoInfinispanContainer)Mockito.doReturn((Object)11111).when((Object)this.container)).getMappedPort(11222);
        Assertions.assertEquals((int)11111, (int)this.container.getMappedPort());
    }
}

