/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers.springboot;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.kie.kogito.testcontainers.springboot.KafkaSpringBootTestResource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

@ExtendWith(value={MockitoExtension.class})
public class KafkaSpringBootTestResourceTest {
    @Mock
    private KogitoKafkaContainer container;
    @Mock
    private ConfigurableListableBeanFactory beanFactory;
    private KafkaSpringBootTestResource resource;

    @Test
    public void shouldGetProperty() {
        this.givenResource();
        Assertions.assertEquals((Object)"spring.kafka.bootstrap-servers", (Object)this.resource.getKogitoProperty());
    }

    @Test
    public void shouldConditionalBeDisabledByDefault() {
        this.givenResource();
        this.thenConditionalIsDisabled();
    }

    @Test
    public void shouldConditionalBeEnabled() {
        this.givenConditionalResource();
        this.thenConditionalIsEnabled();
    }

    @Test
    public void shouldAddKafkaClientInContext() {
        this.givenResource();
        this.givenContainer();
        this.whenUpdateBeanFactory();
        this.thenKafkaClientIsRegistered();
    }

    private void givenConditionalResource() {
        this.resource = (KafkaSpringBootTestResource)Mockito.spy((Object)new KafkaSpringBootTestResource.Conditional());
    }

    private void givenResource() {
        this.resource = (KafkaSpringBootTestResource)Mockito.spy((Object)new KafkaSpringBootTestResource());
    }

    private void givenContainer() {
        ((KafkaSpringBootTestResource)Mockito.doReturn((Object)this.container).when((Object)this.resource)).getTestResource();
    }

    private void whenUpdateBeanFactory() {
        this.resource.updateBeanFactory(this.beanFactory);
    }

    private void thenKafkaClientIsRegistered() {
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.beanFactory)).registerSingleton((String)ArgumentMatchers.eq((Object)KafkaClient.class.getName()), ArgumentMatchers.isA(KafkaClient.class));
    }

    private void thenConditionalIsEnabled() {
        Assertions.assertTrue((boolean)this.resource.isConditionalEnabled());
    }

    private void thenConditionalIsDisabled() {
        Assertions.assertFalse((boolean)this.resource.isConditionalEnabled());
    }
}

